# チャンネルとは
チャンネルは、イメージファイルに含めるファイル（airootfs）やインストールするパッケージ、設定ファイルなどを簡単に切り替えられるように作られたAlterISO独自の仕組みです。  
AlterISO 2の複数アーキテクチャ対応により大幅に仕様が変更されています。また、AlterISO 3の多言語化によってパッケージに関する部分が変更されています。  
チャンネルでAlterLinuxとは全く別物のOSを構成、ビルドすることもできます。（[ArchLinux](https://github.com/FascodeNet/alterlinux/tree/fix-aur/channels/releng)）  
  
以下は2020年8月29日現在でのチャンネルの仕様です。  

# 注意
**このドキュメントはおそらく完全ではありません。**
ドキュメントで不明な部分があったり、事実と一致してない部分、文章がおかしい場合はIssueを作成して下さい。


# ドキュメントの見方
`<arch>`はビルド時のアーキテクチャ名、`<locale>`は言語名、`<ch_name>`はチャンネル名、`<md_name>`はモジュール名に置き換えてください。  


# スクリプトにチャンネルを認識させる
スクリプトがチャンネルを認識する条件は以下のとおりです。

- `channels`内にチャンネル名のディレクトリがある
- そのディレクトリが空ではない
- `alteriso`ファイルが存在し、バージョンがスクリプトと一致する

空のディレクトリを作成したり、別の場所に作成してもスクリプトは認識しません。  
スクリプトがチャンネルを認識したかどうかを確認するには、`./build.sh --channellist`で確認できます。  
ヘルプのチャンネル一覧に表示されていないチャンネルは使用できません。  

# alterisoファイルについて
チャンネルのディレクトリ直下にある`alteriso`には、ビルドできるAlterISOのバージョンが記述されています。  
AlterISO3以降、スクリプトはバージョンが一致したチャンネルのみビルドを行います。  
このファイルが存在しないとチャンネルのバージョンがAlterISO2以下だと判断され、チャンネルとして認識されません。  
2020年7月12日現在のAlterISO3でのバージョンの書き方は以下のとおりです。  

```alteriso
alteriso=3.0
```

# チャンネル名について
チャンネル名は基本的には`channels`内のディレクトリ名です。  
ディレクトリ名に使用できる全ての文字はチャンネル名に利用することができますが、空白文字や全角文字を入れた場合、一部の環境で正常に動作しない可能性が有ります。  
また、チャンネル名はスクリプト内で扱う関係上、18文字以内にすることが望ましいです。（それ以上の文字数ではヘルプでチャンネル名が正常に表示されません。）   
  
もしディレクトリ名が`.add`で終了する場合、チャンネル名は`.add`の前の文字列になります。  
これは、Gitの管理から除外し、カスタマイズした独自のチャンネルを追加するためのものです。  
最終的に引数として使用できるチャンネル名は`./build -h`を実行して確認して下さい。

## チャンネル名の重複について
**チャンネル名が`.add`がついているものといないもので重複しないようにして下さい！**  
`.add`がついているものとついていないものが重複した場合、**`.add`が付いている方が優先**されます。  
`.add`がついていないチャンネルは一切使用不可能になりますのでご注意下さい。  
また、以下の特殊なチャンネルの名前も使用することができません。  


# 特殊なチャンネル
以前にはチャンネル名として使用できない、既に定義された特殊なチャンネルがありました。  
AlterISO 3.1でそれらは完全に廃止され、現在はモジュールとプリセットによって定義されています。  
過去に特殊なチャンネルとして扱われていたものとして`share` `shre-extra` `rebuild`などがあります。

# それぞれのチャンネルの仕様
チャンネルを構成する主要なディレクトリは`airootfs`と`packages`です。  
`airootfs`ディレクトリはパッケージをインストールし`mksquashfs`を実行する直前に`/`を上書きします。  
`packages`ディレクトリはインストールするパッケージのリストを記述したテキストファイルを格納します。  
それ以外にも場合によって使用できるファイルがいくつか有ります。  


## airootfsから始まるディレクトリ
それぞれのディレクトリ内を`/`としてファイルを配置して下さい。全てのファイルの権限はなるべく引き継がれるようになっています。  

### airootfs.any
アーキテクチャに関わらず最初にライブ環境を上書きします。

### airootfs.i686 airootfs.x86_64
`x86_64`アーキテクチャなら`airootfs.x86_64`が、`i686`なら`airootfs.i686`が使用されます。  

### ファイルの重複の優先順位
各チャンネルと`share`チャンネルのファイルでは各チャンネルのファイルが優先されます。  
また、`airootfs.any`と各アーキテクチャ用のディレクトリでは各アーキテクチャ用のものが優先されます。  
以下は`airootfs`のコピーされる順番を示しています。要約すると左が一番優先されず、右が優先されます。  
  
`share/airootfs.any` -> `share/airootfs.<arch>` -> `<ch_name>/airootfs.any` -> `<ch_name>/airootfs.<arch>`


## customize_airootfs.sh
各チャンネルの`airootfs`で、`/root/customize_airootfs_<ch_name>.sh`というファイルが配置された場合、ビルドスクリプトは、`customize_airootfs.sh`が実行された後にそのスクリプトを実行します。  
（`customize_airootfs.sh`は`share`チャンネルの`airootfs.any`によって配置されるため、各チャンネルで自由に上書きすることができます。）
もしrootfsの設定を変更したい場合、このファイルを作成して下さい。
 

## パッケージについて
インストールするパッケージの一覧はテキストファイルによって管理され、ディレクトリ内に配置された、ファイル名が`.<arch>`で終わるがパッケージリストとして読み込まれます。  
1行で1つのパッケージとして扱い、`#`から始まる行はコメントとして扱われます。  

パッケージ名やパッケージリストのファイル名に空白文字や全角文字を含めると正常に動作しない可能性があります。

### 通常のパッケージ
AURのパッケージ以外のパッケージ（リポジトリサーバからバイナリを取得するパッケージ）の一覧は`packagea.<arch>`ディレクトリ以下に配置してください。`airootfs`と違ってアーキテクチャ間の共有はできません。
例えば`x86_64`アーキテクチャならば`packages.x86_64`が読み込まれます。

### AURのパッケージ
AlterISO3ではAURのパッケージの自動ビルドが追加されました。`packages_aur.<arch>`以下の一覧はAURのパッケージとして扱われます。  
スクリプトは内部でyayコマンドを実行します。
ただしrootユーザーでyayコマンドは実行できないため、ビルド用のユーザー`aurbuild`がスクリプトによって自動的に作成されます。  
そのため引数でユーザー名`aurbuild`を指定することはできません。（この例外処理はまだ実装されていませんが将来的に実装予定です。）


### 特殊なパッケージ
以前は`base`パッケージや`base-devel`パッケージは強制的にインストールされたため、チャンネルで指定する必要はありませんでした。  
現在では仕様が変更され、`modules`配列に`base`を追加することで`base`パッケージと`syslinux`パッケージがインストールされます。  
モジュールとプリセットに関する仕様は[こちら](./MODULE.md)を参照してください。


### 言語ごとのパッケージリスト
AlterISO 3になって、以前の`jp.<arch>`と`non-jp.<arch>`は廃止されました。  
これからは`packages.<arch>/lang/<locale>.<arch>`が各言語用のパッケージファイルになります。  
各言語用のパッケージファイルはその言語がビルド時に有効化された場合にのみインストールされるパッケージの一覧です。  
また、「日本語ではないときのみ」に使用される`non-jp.<arch>`と同等のリストはAlterISO 3には存在しません。  
言語名に関する詳細は[こちら](LANG.md)をご覧ください。  

### カーネルごとのパッケージリスト
AlterISO 2ではカーネルパッケージは`build.sh`にハードコートされていました。  
3になってからは指定されたカーネル専用のパッケージリストが作成され、より柔軟にパッケージを管理することができます。  
`packages.<arch>/kernel/<kernel name>.<arch>`が読み込まれます。  
ここにはカーネルのパッケージやそのカーネル専用のパッケージを記述して下さい。  


### ブートスプラッシュ用のパッケージリスト
以前の`theme_pkg`変数は廃止され、パッケージリストからインストールされるようになりました。  
`packages.<arch>/plymouth/*.<arch>`に書かれたパッケージはブートストラップが有効化された場合のみインストールされます。  


### 除外リスト
もしモジュールで指定されているパッケージでどうしてもインストールしたくないパッケージがある場合、各チャンネルの`packages`ディレクトリ内に`exclude`というファイルを作成し、その中にパッケージを記述することでパッケージを除外することができます。  
例えば`aptpac`をインストールしたくない場合、そのチャンネルの`exclude`にパッケージ名を追加することでインストールされなくなります。  
（必要に応じてそのパッケージ用のファイルを各チャンネルのcustomize_airootfsで削除して下さい。）  
パッケージの記述方法はパッケージリストと同様で、1行で1つのパッケージとして扱い、`#`から始まる行はコメントとして扱われます。  
  
AlterISO 3.1よりスクリプトによって強制的にインストールされるパッケージはなくなりました。そのため明示的にインストールされるすべてのパッケージを`exclude`で除外することができます。  
  
また、`exclude`はパッケージを削除するわけではないため依存関係によってインストールされるパッケージを除外することはできません。  

#### additional_exclude_pkg
もしビルドに失敗するなどの理由で一時的にインストールしたくないパッケージが存在する場合、`custom.conf`を使用して`additional_exclude_pkg`配列を設定することでそのパッケージのインストールを除外することができます。


### excludeの適用されるタイミング
`exclude`はパッケージが全て読み込まれた後に適用されます。  
  
パッケージが読み込まれる順番は以下のとおりです、
`share/packages.<arch>` -> `<ch_name>/packages.<arch>`  
  
その後に以下の順番でexcludeが読み込まれ、パッケージが除外されます。  
`share/packages.<arch>/exclude` -> `<ch_name>/packages.<arch>`


## description.txt
これはチャンネルの説明を記述したテキストファイルです。`channels/<ch_name>/description.txt`に配置されます。  
このファイルは必須ではありませんが作成するべきです。このファイルが無い場合、ヘルプには`This channel does not have a description.txt.`と表示されます。  

このファイルは1行で記述することが推奨されています。複数行を記述する必要がある場合、テキストのレイアウトを考えて2行目以降は先頭に19個の半角空白文字を入れたほうが良いでしょう。  
  

## pacman.conf
`channels/<ch_name>/pacman-<arch>.conf`を配置すると、ビルド時にそのファイルを使用します。ただし、インストール後の設定ファイルは置き換えないので`airootfs`で`/etc/pacman.conf`を配置して下さい。  


## syslinux
Syslinuxの設定ファイルを上書きします。設定ファイルの基データは`/syslinux/`にあります。  
設定ファイル名などを変更すると正常に動作しません。公式ではこの仕組みは`releng`チャンネルでのみ使用されています。  
`customized_syslinux=false`に設定することでチャンネルによる設定ファイルの上書きを禁止することができます。  
カーネルパスの変更はこの設定ファイルで行わず、カーネル設定ファイルを使用して下さい。  


## splash.png
`channels/<ch_name>/splash.png`を配置すると、SYSLINUXのライブ起動時のブートローダの背景を変更することができます。  
PNG形式の画像で640x480の画像を配置してください。この変更はインストール後のGrubには影響されません。  


## config.<arch>
既存のビルド設定を上書きするスクリプトです。かならずシェルスクリプトの構文で記述して下さい。  
雛形が`build.sh`と同じ階層に設置してあります。  
各チャンネルのディレクトリに配置された設定ファイルは**引数による設定さえ**上書きしてしまうため、最小限の必須項目のみを記述するようしてください。（例えばPlymouthのテーマ名やパッケージ名など）  
引数によって変更可能な変数をこのファイルで設定することは推奨されていません。  
  
### 警告
スクリプト内では変数のスコープを明示しないでください。また、変数定義以外の処理を記述すると思わぬ動作につながる場合はあります。  


### アーキテクチャごとの設定と優先順位
`channels/<ch_name>/config.any`が読み込まれた後`channels/<ch_name>/config.<arch>`が読み込まれます。  
このアーキテクチャの優先順位はモジュールにおいても共通です。  


## architecture
そのチャンネルで利用可能なアーキテクチャの一覧です。`#`はコメントとして扱われます。  
チャンネル内でカーネル設定ファイルやpacman設定ファイルなどを適切に設定することでアーキテクチャを独自で定義することも可能です。

## kernel_list-<arch>
使用可能なカーネルの一覧を記述します。このファイルが存在しない場合、対応している全てのカーネルを使用可能です。  
`#`はコメントとして扱われます。カーネル設定ファイルと構文は異なり、カーネル名のみを記述して下さい。  
以下は`kernel_list`の例です。以下の場合は`linux-zen`と`linux-rt`のみを許可します。  

```
# Channel kernel list
# Created by John

zen
rt
#lqx
```

## kernel-<arch>
`/system/kernel-<arch>`を置き換える役割を果たします。そのためファイル構文は`/system/kernel-<arch>`と変わりません。  
`kernek_list-<arch>`とは違って使用可能なカーネルの詳細を設定します。  

## README
チャンネルの詳細を書いたテキストファイルです。ビルドには一切影響されませんが、GitHub上で見た際に表示されるので、簡単なガイドの役割を果たします。作成しておいて損はないでしょう。  

## over_isofs
`over_isofs`ディレクトリ内でビルドされるISOファイルの`/`にファイルを上書きします。  
`airootfs`と似ていますが`over_isofs`ではビルドされるイメージファイル内のファイルを直接操作することができます。  
既存のファイルを上書きしてしまうとブートできなくなる可能性があるので注意して下さい。  
`over_isofs`はsquashfsの作成が終わった後にisoファイルを作成する直前で上書きされます。  

## pkgbuild.any pkgbuild.<arch>
チャンネルディレクトリ内に`pkgbuild.any(arch)/任意のディレクトリ名/PKGBUILD`を配置するとmakepkgによってビルドし、インストールされます。  
依存関係もpacmanによって自動的にインストールされますが、注意が必要です。  
自動的にインストールされる依存関係はあくまでArch Linuxの公式リポジトリに存在しているものだけです。  
依存しているパッケージが一つでもAUR上に存在している場合は、その依存パッケージをAURのパッケージリストに書かなければなりません。  
また、PKGBUILDを格納するディレクトリ名は絶対に重複しないようにしてください。
