## モジュールについて
モジュールはチャンネルと同じように構成されたファイルやパッケージリストの集合です。  
ただしチャンネルと違って使用できるのは一部の機能です。
モジュールはチャンネルと違ってビルド時に指定するのではなく、チャンネルの設定ファイル内で指定します。

## モジュールの使い方
モジュールはチャンネルに簡単に機能を追加し、チャンネル間で重複したファイルを作成することを防ぐための新しい構造です。AlterISO 3.1によって追加されました。  
モジュールはチャンネルの`config.<arch>`内で`modules`配列を定義することで使用できます。

## モジュールの場所
`build.sh`と同じ階層の`modules`ディレクトリ内にあるディレクトリによって定義されます。このディレクトリの名前がモジュール名になります。  
例えば`/modules/base/`というモジュールの場合、モジュール名は`base`です。  

## モジュールディレクトリ内のファイル
`airootfs`や`packages`、`packages_aur`、`alteriso`、`architecture`はチャンネルと同じ仕様です。[チャンネルのドキュメント](./CHANNEL.md)を参照してください。  
それ以外のチャンネルの機能（`config`や`pacman.conf`、`splash.png`など）は使用できません。（配置しても無視されます。）  

## プリセットについて
モジュールをたくさん指定するのではなく、モジュール名を束にしてまとめて指定できる仕組みがプリセットです。  
`modules`配列にモジュール名を入れる代わりにプリセット名を入れることで、ビルド時にモジュール名に置き換えられます。  
プリセットは`build.sh`と同じ階層の`presets`内にあるテキストファイルによって定義されています。  
例えば`cli-modules`プリセットは`/presets/cli-modules`で定義されており、中のファイルにモジュール名の一覧が書かれています。  
1行につき1つのモジュールを定義します。`#`で始まる行はコメントとして扱われ、ビルド時は無視されます。

## モジュール名とプリセット名
モジュール名とプリセット名が重複した場合、プリセット名が優先されます。  
そのためプリセット名は最後に`-modules`などをつけることでモジュール名と重複しないようにしてください。 

## ビルドの流れ
以下の流れで最終的なパッケージリストやファイルリストが作成されます。

1. 指定されたチャンネルの`config`を読み込む
2. 定義された`modules`配列をもとにプリセットを読み込み、配列内のプリセットをモジュール名に置き換える
3. この時`modules`配列が定義されてなかった場合、AlterISO 3.0 の仕様に従って `include_extra`の値によって`legacy`プリセットか`legacy_extra`プリセットが設定される
4. プリセット名がモジュール名に置き換えられる
5. 最終的なモジュールの一覧をもとにそれぞれのファイルが読み込まれる

## 互換性
AlterISO 3.0ではモジュール名の代わりに`share`チャンネルや`share-extra`チャンネルが使用されてきました。  
これらは現在はいくつかのモジュールに分解されており、それらと互換性のあるモジュールの一覧が`legacy`、`legacy-extra`として定義されています。  
互換モードとして動作することでAlterISO 3.1では3.0のチャンネルを読み込み、ビルドすることが可能です。  
