::
::  test_uls_dev.bat: test the compiled uls library at the develpment stage.
::  Written by Stanley Hong <link2next@gmail.com>, May 2017.
::

@echo off

set HOMEDIR=%CD%
set EXIT_STAT=0

set ULS_INSTDIR=C:\Program Files\UlsWin
set ULc2CLS=ulc2class.exe
set TARGET_NAMESPACE=uls.collection

if not exist "%ULS_INSTDIR%\Bin\%ULc2CLS%" (
	echo %ULc2CLS%: not found in '%ULS_INSTDIR%'!
	goto end_1
)

set PATH=%ULS_INSTDIR%\Bin;%PATH%

cd ..\resources
set ULS_EXAMPLES_DIR=%CD%
cd "%HOMEDIR%"

set ULc2CLS=%ULc2CLS% -lcs

echo simple --- DumpToks\SimpleLex.cs
%ULc2CLS% -d DumpToks -f SimpleLex -n %TARGET_NAMESPACE%.SimpleLex simple
echo.

echo css3.ulc --- Css3Toks\Css3LexBasis.cs
%ULc2CLS% -d Css3Toks -f Css3LexBasis -n %TARGET_NAMESPACE%.Css3LexBasis -pCSS_ "%ULS_EXAMPLES_DIR%"\css3.ulc
echo.

echo html5.ulc --- Html5Toks\Html5LexBasis.cs
%ULc2CLS% -d Html5Toks -f Html5LexBasis -n %TARGET_NAMESPACE%.Html5LexBasis "%ULS_EXAMPLES_DIR%"\html5.ulc
echo.

echo shell.ulc --- ShellToks\ShellLexBasis.cs
%ULc2CLS% -d ShellToks -f ShellLexBasis -n %TARGET_NAMESPACE%.ShellLexBasis "%ULS_EXAMPLES_DIR%"\shell.ulc
echo.


:end_1
pause
exit %EXIT_STAT%