/*
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

/*
  <file> UlsFactory.h </file>
  <brief>
   This implements ULS API based on C++.NET
  </brief>
  <author>
    Stanley Hong <link2next@gmail.com>, April 2017.
  </author>
*/
#pragma once

#include "UlsToolbase.h"

namespace uls {
	namespace polaris {
#undef _uls_tool_type
#define _uls_tool_type(typ) UlsToolbase::typ##_t

#undef _uls_tool_ptrtype
#define _uls_tool_ptrtype(typ) UlsToolbase::typ##_ptr_t

#undef _uls_tool_type_
#define _uls_tool_type_(typ) UlsToolbase::uls_##typ##_t

#undef _uls_tool_ptrtype_
#define _uls_tool_ptrtype_(typ) UlsToolbase::uls_##typ##_ptr_t

#undef _uls_tool_ptrtype_cast_
#define _uls_tool_ptrtype_cast_(typ, var1, var2) _uls_tool_ptrtype_(typ) var1 = (_uls_tool_ptrtype_(typ)) (var2)

#define ULS_EXCLUDE_HFILES
#include "uls/uls_config.h"
#include "uls/uls_const.h"
#include "uls/uls_type.h"
#undef ULS_EXCLUDE_HFILES

#define ULS_EXCLUDE_HFILES
#define ULS_DECL_GLOBAL_TYPES
#include "uls_all_that.h"
#undef ULS_DECL_GLOBAL_TYPES
#undef ULS_EXCLUDE_HFILES

		public ref class UlsFactory : UlsObject {
#define ULS_EXCLUDE_HFILES
		private:
#define ULS_DECL_PRIVATE_TYPE
#include "uls_all_that.h"
#undef ULS_DECL_PRIVATE_TYPE

		protected:
#define ULS_DECL_PROTECTED_TYPE
#include "uls_all_that.h"
#undef ULS_DECL_PROTECTED_TYPE

		public:
#define ULS_DECL_PUBLIC_TYPE
#include "uls_all_that.h"
#undef ULS_DECL_PUBLIC_TYPE

		private:
#define ULS_DEF_PRIVATE_TYPE
#include "uls_all_that.h"
#undef ULS_DEF_PRIVATE_TYPE

		protected:
#define ULS_DEF_PROTECTED_TYPE
#include "uls_all_that.h"
#undef ULS_DEF_PROTECTED_TYPE

		public:
#define ULS_DEF_PUBLIC_TYPE
#include "uls_all_that.h"
#undef ULS_DEF_PUBLIC_TYPE

		private:
#define ULS_DEF_PRIVATE_DATA
#include "uls_all_that.h"
#undef ULS_DEF_PRIVATE_DATA
			bool isFinalized, isDisposed;

		protected:
			UlsLog ^_log_;
			UlsToolbase ^_tool_;
			UlsToolbase::uls_sysinfo_ptr_t _sysprops_;

#define ULS_DEF_PROTECTED_DATA
#include "uls_all_that.h"
#undef ULS_DEF_PROTECTED_DATA

		public:
#define ULS_DEF_PUBLIC_DATA
#include "uls_all_that.h"
#undef ULS_DEF_PUBLIC_DATA
			static UlsObjectListExp ^objs_list;

		private:
#define ULS_DECL_PRIVATE_PROC
#include "uls_all_that.h"
#undef ULS_DECL_PRIVATE_PROC
			static UlsFactory()
			{
				objs_list = gcnew UlsObjectListExp();
			}

		protected:
#define ULS_DECL_PROTECTED_PROC
#include "uls_all_that.h"
#undef ULS_DECL_PROTECTED_PROC

			// delegate
			_uls_def_callback_this(__keyw_strncmp_case_sensitive, strcmp_proc);
			_uls_def_callback_this(__keyw_strncmp_case_insensitive, strcmp_proc);

			_uls_def_callback_this(__keyw_hashfunc_case_sensitive, hashfunc);
			_uls_def_callback_this(__keyw_hashfunc_case_insensitive, hashfunc);

			_uls_def_callback_this(dfl_lit_analyzer_escape0, litstr_analyzer);
			_uls_def_callback_this(dfl_lit_analyzer_escape1, litstr_analyzer);
			_uls_def_callback_this(dfl_lit_analyzer_escape2, litstr_analyzer);

			_uls_def_callback_this(nothing_lit_analyzer, litstr_analyzer);

			_uls_def_callback_this(uls_gettok_raw, gettok);
			_uls_def_callback_this(uls_gettok_bin, gettok);

			_uls_def_callback_this(__print_uld_lineproc_1, proc_uld_line);
			_uls_def_callback_this(__print_uld_lineproc_2, proc_uld_line);
			_uls_def_callback_this(__print_uld_lineproc_3cpp, proc_uld_line);
			_uls_def_callback_this(__print_uld_lineproc_3cs, proc_uld_line);

			_uls_def_callback_this(uls_input_refill_null, input_refill);
			_uls_def_callback_this(uls_input_refill_buffer, input_refill);
			_uls_def_callback_this(uls_input_refill_cr2lf, input_refill);

			_uls_def_callback_this(uls_fill_null_source, fill_isource);
			_uls_def_callback_this(uls_fill_fd_source_utf8, fill_isource);
			_uls_def_callback_this(uls_fill_fd_source_utf16, fill_isource);
			_uls_def_callback_this(uls_fill_fd_source_utf32, fill_isource);
			_uls_def_callback_this(uls_fill_fd_stream, fill_isource);

			_uls_def_callback_this(uls_ungrab_null_source, ungrab_isource);
			_uls_def_callback_this(uls_ungrab_linecheck, ungrab_isource);
			_uls_def_callback_this(uls_ungrab_fd_utf, ungrab_isource);
			_uls_def_callback_this(uls_ungrab_fd_stream, ungrab_isource);

			_uls_def_callback_this(uls_fd_ungrabber, input_ungrabber);

			_uls_def_callback_this(xcontext_raw_filler, xcontext_filler);
			_uls_def_callback_this(xcontext_binfd_filler, xcontext_filler);
			_uls_def_callback_this(xcontext_txtfd_filler, xcontext_filler);

			_uls_def_callback_this(check_rec_boundary_null, xctx_boundary_checker);
			_uls_def_callback_this(check_rec_boundary_host_order, xctx_boundary_checker);
			_uls_def_callback_this(check_rec_boundary_reverse_order, xctx_boundary_checker);

			_uls_def_callback_this(__check_rec_boundary_host_order, xctx_boundary_checker2);
			_uls_def_callback_this(__check_rec_boundary_reverse_order, xctx_boundary_checker2);

			_uls_def_callback_this(uls_make_pkt__null, make_packet);
			_uls_def_callback_this(uls_make_pkt__bin, make_packet);
			_uls_def_callback_this(uls_make_pkt__txt, make_packet);

			_uls_def_callback_this(uls_make_pkt__bin_lno, make_packet);
			_uls_def_callback_this(uls_make_pkt__txt_lno, make_packet);

			_uls_def_callback_this(uls_reorder_bytes_null, reorder_bytes);
			_uls_def_callback_this(uls_reorder_bytes_binle, reorder_bytes);
			_uls_def_callback_this(uls_reorder_bytes_binbe, reorder_bytes);

			_uls_def_callback_tool_(keyw_stat_comp_by_keyw, sort_cmpfunc);
			_uls_def_callback_tool_(cmp_twoplus_by_length, sort_cmpfunc);
			_uls_def_callback_tool_(cmp_twoplus_vx_by_keyword, sort_cmpfunc);
			_uls_def_callback_tool_(cnst_suffixes_by_len, sort_cmpfunc);
			_uls_def_callback_tool_(comp_vx_by_tokid, sort_cmpfunc);
			_uls_def_callback_tool_(comp_vx_by_toknam, sort_cmpfunc);
			_uls_def_callback_tool_(comp_by_tokid_vx, sort_cmpfunc);
			_uls_def_callback_tool_(commtype_by_length_dsc, sort_cmpfunc);
			_uls_def_callback_tool_(quotetype_by_length_dsc, sort_cmpfunc);
			_uls_def_callback_tool_(keyw_stat_comp_by_freq, sort_cmpfunc);
			_uls_def_callback_tool_(numpfx_by_length_dsc, sort_cmpfunc);

			_uls_def_callback_tool_(srch_vx_by_id, bi_comp);
			_uls_def_callback_tool_(id_range_comp, bi_comp);
			_uls_def_callback_tool_(srch_vx_by_toknam, bi_comp);

			_uls_def_callback_tool_(read_config__CASE_SENSITIVE, cmd_proc);
			_uls_def_callback_tool_(read_config__CHAR_TOK, cmd_proc);
			_uls_def_callback_tool_(read_config__COMMENT_TYPE, cmd_proc);
			_uls_def_callback_tool_(read_config__DECIMAL_SEPARATOR, cmd_proc);
			_uls_def_callback_tool_(read_config__DOMAIN, cmd_proc);
			_uls_def_callback_tool_(read_config__ID_CHARS, cmd_proc);
			_uls_def_callback_tool_(read_config__ID_FIRST_CHARS, cmd_proc);
			_uls_def_callback_tool_(read_config__ID_MAX_LENGTH, cmd_proc);
			_uls_def_callback_tool_(read_config__LINEFEED_GUARD, cmd_proc);
			_uls_def_callback_tool_(read_config__NOT_CHAR_TOK, cmd_proc);
			_uls_def_callback_tool_(read_config__NUMBER_PREFIXES, cmd_proc);
			_uls_def_callback_tool_(read_config__NUMBER_SUFFIXES, cmd_proc);
			_uls_def_callback_tool_(read_config__QUOTE_TYPE, cmd_proc);
			_uls_def_callback_tool_(read_config__RENAME, cmd_proc);

		public:
			UlsFactory();
			virtual ~UlsFactory();
			virtual void finalizer() override;
			!UlsFactory();

			UlsToolbase ^getUlsToolbase()
			{
				return _tool_;
			}

			static void releaseUlsObjectList()
			{
				UlsObject::finalizeUlsObjectList(objs_list);
				objs_list = nullptr;
			}

#define ULS_DECL_PUBLIC_PROC
#include "uls_all_that.h"
#undef ULS_DECL_PUBLIC_PROC

#undef ULS_EXCLUDE_HFILES
		};
	} //  End of polaris
} // End of uls
