/*
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

/*
  <file> UlsObject.h </file>
  <brief>
   This implements basic class.
  </brief>
  <author>
    Stanley Hong <link2next@gmail.com>, Oct. 2017.
  </author>
*/
#pragma once

namespace uls {
	namespace polaris {
#define ULS_EXCLUDE_HFILES
#include "uls/uls_config.h"
#undef ULS_EXCLUDE_HFILES
		ref class UlsObject;
		public ref struct UlsObjectListExp {
			array<UlsObject ^> ^lst;
			int n, siz;

			UlsObjectListExp() {
				siz = 8;
				lst = gcnew array<UlsObject ^>(siz);
				n = 0;
			}
		};

		public ref class UlsObject
		{
			int i_uls_obj;

			// <brief>
			// 
			// </brief>
			static HANDLE sys_global_lock;

			// <brief>
			// 
			// </brief>
			static UlsObject::UlsObject();

		public:
			// <brief>
			// 
			// </brief>
			UlsObject();

			// <brief>
			// 
			// </brief>
			static void sysLock();
			static void sysUnlock();

			// <brief>
			// 
			// </brief>
			void changeUlsObjectIndex(int ind);
			void addUlsObject2List(UlsObjectListExp ^list);
			void delUlsObject2List(UlsObjectListExp ^list);

			// <brief>
			//
			// </brief>
			static void finalizeUlsObjectList(UlsObjectListExp ^list);

			// <brief>
			// 
			// </brief>
			static void deInitializeClass();

			// <brief>
			// 
			// </brief>
			virtual void finalizer();
		};
	} //  End of polaris
} // End of uls
