/*
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

/*
  <file> UlsStream.cpp </file>
  <brief>
  </brief>
  <author>
    Stanley Hong <link2next@gmail.com>, April 2017.
  </author>
*/
#include "Stdafx.h"

#include "UlsUtil.h"
#include "UlsLex.h"
#include "UlsStream.h"

using namespace System;
using namespace uls::util;

namespace uls {
namespace polaris {

	//
	// UlsTmplList
	//
#define ULS_CLASS_NAME UlsTmplList
	static ULS_CLASS_NAME::ULS_CLASS_NAME()
	{
		uf = UlsLex::getUlsFactory();
	}

	void ULS_CLASS_NAME::init_uls_tmpllist(int size)
	{
		hash_tbl = gcnew Dictionary<String^, String^>();
		isDisposed = false;
	}

	ULS_CLASS_NAME::ULS_CLASS_NAME(int size)
	{
		init_uls_tmpllist(size);
	}

	ULS_CLASS_NAME::ULS_CLASS_NAME()
	{
		init_uls_tmpllist(0);
	}

	ULS_CLASS_NAME::~ULS_CLASS_NAME()
	{
		if (isDisposed) return;
		hash_tbl->Clear();
		hash_tbl = nullptr;
		isDisposed = true;
	}

	void ULS_CLASS_NAME::clear()
	{
		hash_tbl->Clear();
	}

	bool ULS_CLASS_NAME::exist(String ^nam)
	{
		bool rval;

		if (hash_tbl->ContainsKey(nam))
        {
            rval = true;
        } else {
            rval = false;
        }

        return rval;
	}

	int ULS_CLASS_NAME::length()
	{
		return hash_tbl->Count;
	}

	void ULS_CLASS_NAME::add(String ^nam, String ^val)
	{
		if (hash_tbl == nullptr) {
			hash_tbl = gcnew Dictionary<String^, String^>();
		}

		hash_tbl->Add(nam, val);
	}

	String ^ULS_CLASS_NAME::getValue(String ^nam)
	{
		String ^str;

		if (hash_tbl->ContainsKey(nam))
        {
            str = hash_tbl[nam];
        } else {
            str = nullptr;
        }
                
        return str;
	}

	bool ULS_CLASS_NAME::setValue(String ^nam, String ^val)
	{
		bool rval;
		
		if (hash_tbl->ContainsKey(nam))
		{
			hash_tbl->Add(nam, val);
			rval = true;
		} else {
			rval = false;
		}

		return rval;
	}

	UlsFactory::uls_tmpl_list_t ^ULS_CLASS_NAME::exportTmpls()
	{
		UlsFactory::uls_tmpl_list_t ^tmpl_list;
		str2utf8bytes_t nam_cpp, val_cpp;
		const char *nam, *val;

		tmpl_list = uf->uls_create_tmpls(8, ULS_TMPLS_DUP);
		uf->uls_reset_tmpls(tmpl_list, length());

		for each (KeyValuePair<String^, String^> ^pair in hash_tbl) {
			nam = nam_cpp.set(pair->Key);
			val = val_cpp.set(pair->Value);

			uf->uls_add_tmpl(tmpl_list, nam, val);
		}

		return tmpl_list;
	}

	void ULS_CLASS_NAME::dump()
	{
		for each (KeyValuePair<String^, String^> ^pair in hash_tbl)
		{
			Console::WriteLine("{0} :: '{1}'", pair->Key, pair->Value);
		}
	}

#undef ULS_CLASS_NAME

	//
	// UlsStream
	//
#define ULS_CLASS_NAME UlsStream
	static ULS_CLASS_NAME::ULS_CLASS_NAME()
	{
		uf = UlsLex::getUlsFactory();
	}

	ULS_CLASS_NAME::ULS_CLASS_NAME(bool rdonly)
	{
		read_only = rdonly;
	}

	ULS_CLASS_NAME::ULS_CLASS_NAME()
	{
		read_only = true;
	}

#undef ULS_CLASS_NAME

} // End of polaris
} // End of uls
