/*
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

/*
  <file> UlsUtil.h </file>
  <brief>
  </brief>
  <author>
    Stanley Hong <link2next@gmail.com>, April 2017.
  </author>
*/
#pragma once

using namespace System;

namespace uls {
namespace util {
	public ref class str2utf8bytes_t {
		bool isDisposed;
		int siz_cstr;
		void resize_str2buf(int siz);
		void finalizer();

	  public:
		str2utf8bytes_t();
		str2utf8bytes_t(String ^str);
		virtual ~str2utf8bytes_t();
		!str2utf8bytes_t();

	  	char *cstr;
		int len_cstr;

		char *set(String ^str);
	  	void reset(int siz);
		void deinit();

	  	String ^cvt_utf8bytes(const char *cstr, int len);
	  	String ^cvt_utf8bytes(const char *cstr);
	};

	public ref class UlsTools {
	public:
		delegate int _uls_delegate_getopts_proc(int opt, String ^optarg);
		typedef _uls_delegate_getopts_proc ^uls_getopts_proc_t;

	private:
		static int getopts_chars(array<String ^> ^args, const char *optfmt_cstr, uls_getopts_proc_t proc);

	public:
		UlsTools();
		virtual ~UlsTools();

		// <brief>
		// A C++/CLI brief version of getopt()
		// </brief>
		// <parm name="args">Array of Strings</parm>
		// <parm name="optfmt">The format string consisting of permitted option chars</parm>
		// <parm name="proc">The procedure of option character and 'optarg'</parm>
		// <return>the index 'i0' is the index of the first non-option, argument,
		// i.e., args[i0] doesn't start with the char '-'.</return>
		static int getopts(array<String ^> ^args, String ^optfmt, uls_getopts_proc_t proc);

		// <brief>
		// Get the basename of file-path!
		// Returns 'basename.c when the 'filepath' is '\a\b\basename.c'.
		// </brief>
		// <parm name="filepath">input path string</parm>
		static String ^uls_filename(String ^filepath);
	};
}
}
