#!/bin/bash

HOME_DIR=$PWD

WORK_DIR=../src
if [ ! -d "$WORK_DIR" ]; then
	echo "$WORK_DIR: not found!"
	exit 1
fi

ULSJNI_HOME=".."
if [ ! -d "$ULSJNI_HOME" ]; then
	echo "$ULSJNI_HOME: not found!"
	exit 1
fi

cd "$ULSJNI_HOME"
ULSJNI_HOME=$PWD
cd "$HOME_DIR"

TESTS_DIR=$ULSJNI_HOME/tests

uls_sysprops_fpath=/usr/local/etc/uls/uls.sysprops
if [ ! -f "$uls_sysprops_fpath" ]; then
	echo "$uls_sysprops_fpath: not found!"
	exit 1
fi

testinfo_fpath=$ULSJNI_HOME/ulsjni.config
if [ ! -f "$testinfo_fpath" ]; then
	echo "$testinfo_fpath: not found!"
	exit 1
fi

get_uls_testinfo()
{
	while read line; do
		if [ -z "$line" ]; then
			continue
		fi
		eval $line
	done  < "$uls_sysprops_fpath"

	while read line; do
		if [ -z "$line" ]; then
			continue
		fi
		eval $line
	done  < "$testinfo_fpath"
}

get_uls_testinfo

ULS_VERSION=${ULS_VERSION_MAJOR}.${ULS_VERSION_MINOR}.${ULS_VERSION_DEBUG}
echo "ULS_VERSION='$ULS_VERSION'"
echo "ULS_HOME='$ULS_HOME'"

ULS_JAR_FILE=uls-$ULS_VERSION.jar
ULS_CLASSPATH=.:$ULSJNI_HOME/libs/$ULS_JAR_FILE
if [ -n "$ULS_CLASSPATH" ]; then
	OPT_CP="-cp $ULS_CLASSPATH"
else
	OPT_CP=""
fi

LIB_PATH=$ULSJNI_HOME/libs:$ULS_HOME/lib
export LD_LIBRARY_PATH=$LIB_PATH

echo "LIB_PATH = '$LIB_PATH'"
cd "$WORK_DIR"

java -Djava.library.path=$LIB_PATH $OPT_CP uls.tests.UlsDump input1.txt $TESTS_DIR
java -Djava.library.path=$LIB_PATH $OPT_CP uls.tests.UlsTestStream $TESTS_DIR

cd "$ULSJNI_HOME"
