/*
 * Note: this file originally auto-generated by mib2c using
 *  : mib2c.iterate.conf,v 5.14.2.2 2005/05/09 08:13:01 dts12 Exp $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

#include "l7vsagent.h"
#include "l7vsRealTable.h"


/** Initializes the l7vsRealTable module */
void
init_l7vsRealTable(void)
{
    /*
     * here we initialize all the tables we're planning on supporting
     */
    initialize_table_l7vsRealTable();
}


/** Initialize the l7vsRealTable table by defining its contents and how it's structured */
void
initialize_table_l7vsRealTable(void)
{
    static oid      l7vsRealTable_oid[] =
        { 1, 3, 6, 1, 4, 1, 9999, 1, 18 };
    size_t          l7vsRealTable_oid_len = OID_LENGTH(l7vsRealTable_oid);
    netsnmp_handler_registration *reg;
    netsnmp_iterator_info *iinfo;
    netsnmp_table_registration_info *table_info;

    reg =
        netsnmp_create_handler_registration("l7vsRealTable",
                                            l7vsRealTable_handler,
                                            l7vsRealTable_oid,
                                            l7vsRealTable_oid_len,
                                            HANDLER_CAN_RONLY);

    table_info = SNMP_MALLOC_TYPEDEF(netsnmp_table_registration_info);
    netsnmp_table_helper_add_indexes(table_info, ASN_INTEGER,   /* index: l7vsRealServiceNumber */
                                     ASN_INTEGER,       /* index: l7vsRealServerNumber */
                                     0);
    table_info->min_column = 1;
    table_info->max_column = 8;

    iinfo = SNMP_MALLOC_TYPEDEF(netsnmp_iterator_info);
    iinfo->get_first_data_point = l7vsRealTable_get_first_data_point;
    iinfo->get_next_data_point = l7vsRealTable_get_next_data_point;
    iinfo->table_reginfo = table_info;

    netsnmp_register_table_iterator(reg, iinfo);

    /*
     * Initialise the contents of the table here
     */
	netsnmp_inject_handler(reg,
		netsnmp_get_cache_handler(CACHE_TIME_OUT,
						l7vsRealTable_load,
						l7vsRealTable_free,
						l7vsRealTable_oid,
						OID_LENGTH(l7vsRealTable_oid)
					  )
				);
}


/*
 * create a new row in the (unsorted) table
 * This is called by l7vsagent.c when creating the linked list.
 */
struct l7vsRealTable_entry *
l7vsRealTable_createEntry(long l7vsRealServiceNumber,
                          long l7vsRealServerNumber)
{
    struct l7vsRealTable_entry *entry;

    entry = SNMP_MALLOC_TYPEDEF(struct l7vsRealTable_entry);
    if (!entry)
        return NULL;

    entry->l7vsRealServiceNumber = l7vsRealServiceNumber;
    entry->l7vsRealServerNumber = l7vsRealServerNumber;
    entry->next = l7vsRealTable_head;
    l7vsRealTable_head = entry;
    return entry;
}


/*
 * Example iterator hook routines - using 'get_next' to do most of the work
 * This is invoked when SNMPGET/SNMPWALK/SNMPGETNEXT requests are called
 */
netsnmp_variable_list *
l7vsRealTable_get_first_data_point(void **my_loop_context,
                                   void **my_data_context,
                                   netsnmp_variable_list * put_index_data,
                                   netsnmp_iterator_info *mydata)
{
	/* Creating the linked list */

	if(l7vsRealTable_head == NULL)
		return NULL;

    *my_loop_context = l7vsRealTable_head;
    return l7vsRealTable_get_next_data_point(my_loop_context,
                                             my_data_context,
                                             put_index_data, mydata);
}


/*
 * Example iterator hook routine
 * This is invoked when SNMPGET/SNMPWALK/SNMPGETNEXT requests are called
 */
netsnmp_variable_list *
l7vsRealTable_get_next_data_point(void **my_loop_context,
                                  void **my_data_context,
                                  netsnmp_variable_list * put_index_data,
                                  netsnmp_iterator_info *mydata)
{
    struct l7vsRealTable_entry *entry =
        (struct l7vsRealTable_entry *) *my_loop_context;
    netsnmp_variable_list *idx = put_index_data;

    if (entry) {
        snmp_set_var_value(idx, (u_char*) &entry->l7vsRealServiceNumber,
                           sizeof(entry->l7vsRealServiceNumber));
        idx = idx->next_variable;
        snmp_set_var_value(idx, (u_char*) &entry->l7vsRealServerNumber,
                           sizeof(entry->l7vsRealServerNumber));
        idx = idx->next_variable;
        *my_data_context = (void *) entry;
        *my_loop_context = (void *) entry->next;
	return put_index_data;
    } else {
        return NULL;
    }
}


/** This handles requests for the l7vsRealTable table */
int
l7vsRealTable_handler(netsnmp_mib_handler *handler,
                      netsnmp_handler_registration *reginfo,
                      netsnmp_agent_request_info *reqinfo,
                      netsnmp_request_info *requests)
{

    netsnmp_request_info *request;
    netsnmp_table_request_info *table_info;
    struct l7vsRealTable_entry *table_entry;

    switch (reqinfo->mode) {
        /*
         * Read-support (also covers GetNext requests)
         */
    case MODE_GET:
        for (request = requests; request; request = request->next) {
            table_entry = (struct l7vsRealTable_entry *)
                netsnmp_extract_iterator_context(request);
            table_info = netsnmp_extract_table_info(request);

            switch (table_info->colnum) {
            case COLUMN_L7VSREALSERVICENUMBER:
                snmp_set_var_typed_value(request->requestvb, ASN_INTEGER,
                                         (u_char*)&table_entry->
                                         l7vsRealServiceNumber,
                                         sizeof(table_entry->
                                                l7vsRealServiceNumber));
                break;
            case COLUMN_L7VSREALSERVERNUMBER:
                snmp_set_var_typed_value(request->requestvb, ASN_INTEGER,
                                         (u_char*)&table_entry->l7vsRealServerNumber,
                                         sizeof(table_entry->
                                                l7vsRealServerNumber));
                break;
            case COLUMN_L7VSREALSERVERADDR:
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         (u_char*) table_entry->l7vsRealServerAddr,
                                         strlen(table_entry->
                                                l7vsRealServerAddr)+1);
                break;
            case COLUMN_L7VSREALSERVERPORT:
                snmp_set_var_typed_value(request->requestvb, ASN_INTEGER,
                                         (u_char*) &table_entry->l7vsRealServerPort,
                                         sizeof(table_entry->
                                                l7vsRealServerPort));
                break;
            case COLUMN_L7VSREALSERVERFLAG:
                snmp_set_var_typed_value(request->requestvb, ASN_INTEGER,
                                         (u_char*)&table_entry->l7vsRealServerFlag,
                                         sizeof(table_entry->
                                                l7vsRealServerFlag));
                break;
            case COLUMN_L7VSREALSERVERWEIGHT:
                snmp_set_var_typed_value(request->requestvb, ASN_INTEGER,
                                         (u_char*)&table_entry->l7vsRealServerWeight,
                                         sizeof(table_entry->
                                                l7vsRealServerWeight));
                break;
            case COLUMN_L7VSREALSERVERACTIVECONN:
                snmp_set_var_typed_value(request->requestvb, ASN_INTEGER,
                                         (u_char*)&table_entry->
                                         l7vsRealServerActiveConn,
                                         sizeof(table_entry->
                                                l7vsRealServerActiveConn));
                break;
            case COLUMN_L7VSREALSERVERINACTIVECONN:
                snmp_set_var_typed_value(request->requestvb, ASN_INTEGER,
                                         (u_char*)&table_entry->
                                         l7vsRealServerInactiveConn,
                                         sizeof(table_entry->
                                                l7vsRealServerInactiveConn));
                break;
            }
        }
        break;

    }

    return SNMP_ERR_NOERROR;
}


/* Populates the Virtual service and real server linked list */
int l7vsRealTable_load(netsnmp_cache* cache, void* vmagic)
{
	populateServiceTable();
	return 0;
}


/* Frees off the linked lists of Virtual service and real server */
void l7vsRealTable_free(netsnmp_cache* cache, void* vmagic)
{
	freeVirtualServiceTableMemory();
	freeRealServerTableMemory();
	return;
}
