#!/usr/bin/env bash
#
# Copyright (C) 2003 VA Linux Systems Japan, K.K.
#
# LICENSE NOTICE
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#

# $Id: backup.sh,v 1.7 2004/04/02 02:34:09 taru Exp $

set -e

eval `ultrapossum-config init`
trap "eval `ultrapossum-config term`" 0

if test "x$SLAPD_VERSION" = "2.0"; then
  echo "E: can't backup when slapd $SLAPD_VERSION is running" 1>&2
  exit 1
fi

install -d $BACKUPDIR

backup=$BACKUPDIR/$SUFFIX-`date +%Y%m%d`.ldif

if test -f "$backup.gz"; then
  echo "W: $backup.bz already exist" 1>&2
else
  echo -n "Checking for $SUFFIX... "
  touch $backup
  chmod 600 $backup
  slapcat -b $SUFFIX > $backup
  echo "done"
  latest=`/bin/ls $BACKUPDIR/$SUFFIX-*.gz 2> /dev/null | sort -r | head -1`
  if test -f "$latest" && zcat $latest | diff -q - $backup > /dev/null; then
    echo -n "Sliding `basename $latest` to `basename $backup.gz`... "
    /bin/rm $backup
    /bin/mv $latest $backup.gz
    echo "done"
  else
    echo -n "Backing up $SUFFIX... "
    gzip $backup
    echo "done"
  fi

fi

