#
# Copyright (C) 2003 VA Linux Systems Japan, K.K.
#
# LICENSE NOTICE
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#

# $Id: Conf.pm,v 1.3 2004/04/02 02:34:22 taru Exp $

package UltraPossum::Conf;

use 5.008;
use strict;
use warnings;

require Exporter;
use AutoLoader qw(AUTOLOAD);

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use UltraPossum ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
	
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	
);

# Preloaded methods go here.

sub new {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $vars=`ultrapossum-config get`;
        my $hash = {};
        foreach (split(/\n/, $vars)) {
                if(/^([^=]+)="(.+)"$/) {
                        $hash->{$1} = $2;
                }
        }
        my $this=bless($hash, $class);
                                                                                
        return $this;
}


# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

UltraPossum::Conf - Perl interface for UltraPossum meta-configuraiton

=head1 SYNOPSIS

  use UltraPossum::Conf;

=head1 DESCRIPTION

UltraPossum:Conf provides you to access UltraPossum meta-configuraiton
system. Currently, you can only get configurations from meta-configuraiton
and not set them.

=head1 EXAMPLE

	my $conf = UltraPossum::Conf->new;
	print $conf->{HOST} . "\n";


=head1 AUTHOR

Masato Taruishi, E<lt>taru@valinux.co.jpE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright 2003 by VA Linux Systems Japan, Inc.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself. 

=cut
