#!/usr/bin/env bash
#
# Copyright (C) 2003 VA Linux Systems Japan, K.K.
#
# LICENSE NOTICE
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#

# $Id: createdb.sh,v 1.15 2004/05/12 03:27:14 taru Exp $

#  createdb.sh [restore [<format>]]

set -e

eval `ultrapossum-config init` 2> /dev/null

if test -d "$DIRECTORY"; then
  echo "W: $DIRECTORY already exist" 1>&2
  exit 0
fi

if test "x$DBWORKDIR" != "x"; then
  echo -n "Preparing database working directory: $DBWORKDIR... " 1>&2
  DBWORKDIR="$DBWORKDIR/ultrapossum-createdb.$$"
  install -d $DBWORKDIR
  ln -s $DBWORKDIR $DIRECTORY
  echo "done" 1>&2
else
  install -d $DIRECTORY > /dev/null
fi

touch $DIRECTORY/ultrapossum-environ
chmod 600 $DIRECTORY/ultrapossum-environ
getconfig > $DIRECTORY/ultrapossum-environ

if test "x$HOST" != "x$MASTER" && include "$HOST" "$SYNCBACKUPS"; then
  exit 0
fi

format=ldif
if test "x$2" != "x"; then
  format=$2
fi

term() {
  /bin/rm -f $tmp
  if test "x$DBWORKDIR" != "x"; then
    /bin/rm -rf $DBWORKDIR
    if test -L "$DIRECTORY"; then
      /bin/rm $DIRECTORY
    fi
  fi
  eval `ultrapossum-config term`
}

# find_latest <format>
find_latest()
{
 latest=`/bin/ls $BACKUPDIR/$SUFFIX-*$1.gz 2> /dev/null | sort -r | head -1`
 if ! test -f "$latest"; then
   echo "E: can't find any backup" 1>&2
   /bin/rm -rf $DIRECTORY
   exit 1
 fi
 echo $latest
}

case "x$format" in
  xldif)

tmp=`tempfile`
chmod 600 $tmp
trap "eval 'term'" 0

if test "x$1" = "xrestore"; then
 ldiffile=$tmp
 latest=`find_latest "ldif"`
 echo -n "Preparing resotre environment for `basename $latest`... " 1>&2
 zcat $latest > $tmp
 echo "done" 1>&2
elif test "x$HOST" = "x$MASTER"; then
 ldiffile=$tmp
 cat $ULTRAPOSSUMLDIF > $tmp
 echo "" >> $tmp
 extraldifs="$APPSLDIF"
 if test -f "$INITLDIF" && egrep "^dn: " "$INITLDIF" > /dev/null; then
   extraldifs="$extraldifs $INITLDIF"
 fi
 extraldifs="$extraldifs `find $INITLDIFDIR -type f | sort | tr '\n' ' '`"
else
 ldiffile=$DIRECTORY/$HOST.ldif
 if ! test -s $ldiffile; then
   if ssh $MASTER "cat $DIRECTORY/$HOST.ldif && cp /dev/null $DIRECTORY/$HOST.ldif" > $ldiffile; then
     if ! test -s $ldiffile; then
       echo "E: Initial LDIF file already fetched." 1>&2
       /bin/rm -rf $DIRECTORY
       exit 1
     fi
   else
     echo "E: fail to fetch the initial directory from $MASTER" 1>&2
     /bin/rm -rf $DIRECTORY
     exit 1
   fi
 fi
fi

echo -n "Creating Initial Directory in $DIRECTORY... " 1>&2
if $SLAPADD -b $SUFFIX -f $SLAPDCONF $SLAPADD_EXTRA_ARGS < $ldiffile; then
  echo "done" 1>&2
else
  /bin/rm -rf $DIRECTORY
  echo "failed" 1>&2
  exit 1
fi

for l in $extraldifs
do
  echo -n "Setting up `basename $l .ldif` entries... " 1>&2
  if $SLAPADD -b $SUFFIX -f $SLAPDCONF $SLAPADD_EXTRA_ARGS < $l; then
    echo "done" 1>&2
  else
    /bin/rm -rf $DIRECTORY
    echo "failed" 1>&2
    exit 1
  fi
done

 ;;
 xtar)
   latest=`find_latest "tar"`
   (cd $DIRECTORY; tar zxf $latest )
 ;;
 x*)
   echo "unknown format: $format" 1>&2
   exit 1
 ;;
esac

if test "x$DBWORKDIR" != "x"; then
  echo -n "Adjusting database... " 1>&2
  /bin/rm $DIRECTORY
  /bin/cp -rp $DBWORKDIR $DIRECTORY
  echo "done" 1>&2
fi
