(in-package :unf)

(eval-when (:compile-toplevel)
 (let ((root (pathname (directory-namestring *compile-file-pathname*))))
   (defun load-canonical-combining-class ()
     (coerce
      (with-open-file (in (merge-pathnames "data/canonical-combining-class.lisp" root))
        (read in))
      '(vector (unsigned-byte 8))))
   
   (defun load-decomposition-mapping (type)
     (let ((filepath (merge-pathnames (format nil "data/~(~A~)-decomposition-map.lisp" type) root)))
       (map 'vector
            (lambda (o)
              (if (null o)
                  o
                (map 'string #'code-char o)))
            (with-open-file (in filepath)
              (read in)))))

   (defun load-illegal-char-list (form)
     (coerce (with-open-file (in (merge-pathnames (format nil "data/~(~A~)-illegal-char.lisp" form) root))
               (read in))
             'bit-vector))

   (defun load-canonical-composition-mapping ()
     (let ((map (make-hash-table :test #'equal)))
       (loop FOR ((c1 . c2) . v) IN (with-open-file (in (merge-pathnames "data/canonical-composition-map.lisp" root))
                                      (read in))
         DO
         (setf (gethash (cons (code-char c1) (code-char c2)) map) (code-char v)))
       map))))

(define-constant +CCC+ #.(load-canonical-combining-class))
(define-constant +CDM+ #.(load-decomposition-mapping :canonical))
(define-constant +KDM+ #.(load-decomposition-mapping :compatibility))
(define-constant +CCM+ #.(load-canonical-composition-mapping))
(define-constant +CIL+ #.(load-illegal-char-list :nfc))
(define-constant +KIL+ #.(load-illegal-char-list :nfkc))
