(in-package :unf)

(declaim (inline make-string-builder
                 new-string-builder 
                 string-builder-add
                 string-builder-append
                 string-builder-replace
                 string-builder-ref
                 string-builder-to-string))

(defstruct string-builder
  (buf "" :type simple-characters)
  (pos 0  :type array-index))

(defun new-string-builder (hint)
  (make-string-builder :buf (make-string (max 10 (the array-index (round (* hint 1.5)))))))

(defun string-builder-add (sb ch)
  (with-slots (buf pos) sb
    (when (= pos (length buf))
      (setf buf (adjust-array buf (* (length buf) 2))))
    (setf (aref buf pos) ch)
    (incf pos)))

(defun string-builder-append (sb s &key (start 0) (end (length s)) &aux (len (- end start)))
  (with-slots (buf pos) sb
    (when (> (+ len pos) (length buf))
      (setf buf (adjust-array buf (+ (* (length buf) 2) len))))
    (loop FOR j FROM start BELOW end
          FOR i FROM pos
      DO
      (setf (aref buf i) (aref s j)))
    (incf pos len)))

(defun string-builder-replace (sb index new-char)
  (with-slots (buf) sb
    (setf (aref buf index) new-char)))

(defun string-builder-ref (sb index)
  (aref (string-builder-buf sb) index))

(defun string-builder-to-string (sb)
  (with-slots (buf pos) sb
    (subseq buf 0 pos)))

(defmacro with-string-builder ((sb hint) &body body)
  `(let ((,sb (new-string-builder ,hint)))
     ,@body
     (string-builder-to-string ,sb)))