/* $Id: check.c,v 1.3 2003/09/28 15:16:15 mac Exp $
* passwd checker
*
* copyleft 2003 mac@research.co.jp
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "uauth.h"

int
checkpasswd(void)
{
	GDBM_FILE               dbf;
	FILE                   *fusb;
	char                    buf[N_CRYPT];
	datum                   duser, dpasswd;
	int                     ret;

	if (mount(authDEV, Mpoint, Mtype,
			(MS_MGC_VAL | MS_SYNCHRONOUS), NULL) != 0) {
		perror(progname);
		exit(errno);
	}
	sprintf(name, "%s/%s", Mpoint, hostname);
	if ((fusb = fopen(name, "r")) == NULL) {
		umount(Mpoint);
		fprintf(stderr, "%s: Mount error\n", progname);
		perror(progname);
		exit(errno);
	}
	fgets(buf, N_USER, fusb);
	sscanf(buf, "%s", user);

	if ((dbf = gdbm_open(DBname, BUFSIZ, (GDBM_READER | GDBM_SYNC),
				0600, NULL)) == NULL) {
		fprintf(stderr, "%s: gdbm error at open %s\n\t%s\n",
			progname, DBname, gdbm_strerror(gdbm_errno));
		umount(Mpoint);
		exit(false);
	}

	duser.dsize = strlen(user);
	duser.dptr = user;

	dpasswd = gdbm_fetch(dbf, duser);
	if (dpasswd.dptr == NULL) {
		fprintf(stderr, "%s: I don't know user %s\n", progname, user);
		umount(Mpoint);
		exit(false);
	}

	fread(buf, N_CRYPT, 1, fusb);
	fclose(fusb);
	umount(Mpoint);
	ret = memcmp(dpasswd.dptr, buf, dpasswd.dsize);
#ifdef DEBUG
	int                     i;
	unsigned char          *p, *q;
	int                     p = (char *) dpasswd.dptr;
	int                     q = buf;
	for (i = 0; i < 16; i++) {
		fprintf(stderr, "%02x ", *p++);
	};
	putc('\n', stderr);
	for (i = 0; i < 16; i++) {
		fprintf(stderr, "%02x ", *q++);
	};
#endif
	free(dpasswd.dptr);
	gdbm_close(dbf);

	if (ret != 0) {
		return (false);
	}
	return (true);
}
