/* $Id: main.c,v 1.3 2003/09/28 15:16:15 mac Exp $
* usbauth check core
*
* copyleft 2003 mac@research.co.jp
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#define MAIN

#include "uauth.h"

#define f_a	1
#define f_r	2
#define f_d	4
#define f_f	8
#define f_arg	16
#define f_err	128

int
main(int argc, char *argv[])
{
	int                     optflag, c;
	int                     i;
	static struct option    long_options[] = {
		{"add", required_argument, NULL, 'a'}, {"remove",
			required_argument, NULL, 'r'}, {"dev",
			required_argument, NULL, 'd'}, {"dbfile",
			required_argument, NULL, 'f'}, {"help",
			optional_argument, NULL, 'h'}, {"version",
			optional_argument, NULL, 'v'}, {0, 0, 0, 0}
	};
	strncpy(progname, argv[0], MAXPATHLEN);
	strncpy(DBname, DefualtDB, MAXPATHLEN);
	strncpy(authDEV, DefualtDEV, MAXPATHLEN);
	gethostname(hostname, MAXPATHLEN);
	optflag = 0;

	while (1) {
		int                     option_index = 0;
		c = getopt_long(argc, argv, "a:r:d:f:hvV",
			long_options, &option_index);
		if (c == -1)
			break;
		switch (c) {
		 case 'a':
			 if (optarg) {
				 optflag |= f_a;
				 strncpy(user, optarg, N_USER);
			 }
			 break;
		 case 'r':
			 if (optarg) {
				 optflag |= f_r;
				 strncpy(user, optarg, N_USER);
			 }
			 break;
		 case 'd':
			 if (optarg) {
				 optflag |= f_d;
				 strncpy(authDEV, optarg, MAXPATHLEN);
			 }
			 else {
				 optflag |= f_arg;
			 }
			 break;
		 case 'f':
			 if (optarg) {
				 strncpy(DBname, optarg, N_USER);
				 optflag |= f_f;
			 }
			 else {
				 optflag |= f_arg;
			 }
			 break;
		 case 'h':
			 optflag |= f_err;
			 break;
		 case 'v':
		 case 'V':
			 fprintf(stderr,
				 "%s version %s is an authentication system\n",
				 progname, Version());
			 fprintf(stderr,
				 "%s is free software;"
				 "you can redistribute it and/or modify"
				 "it under the terms of the GNU General Public License"
				 "as published by the Free Software Foundation;"
				 "either version 2 of the License,"
				 "or any later version.\n", progname);
			 return (0);
		 case '?':
		 default:
			 optflag |= f_err;
			 fprintf(stderr,
				 "%s: unknown option -%c (0x%02x)\n",
				 progname, c, c & 0xff);
			 break;
		}
	}

	if (optflag & f_arg) {
		fprintf(stderr,
			"%s: option (-%c) needs an argment\n", progname, c);
		optflag |= f_err;
	}

	while (optind < argc) {
		fprintf(stderr,
			"%s: ignore argument %s\n", progname, argv[optind++]);
		optflag |= f_err;
	}

	if (optflag & f_err) {
		usage();
		return (EINVAL);
	}

	else if ((optflag & (f_a | f_r)) == (f_a | f_r)) {
		fprintf(stderr,
			"%s; Can't select add and remove at the same time\n",
			progname);
		return (EINVAL);
	}

	if (getuid() != 0) {
		fprintf(stderr, "%s: Only root can use this program\n",
			progname);
		exit(EACCES);
	}

	gethostname(hostname, N_HOSTNAME);

	if (optflag & f_r) {
		return (deluser());
	}

	if (optflag & f_a) {
		newpasswd();
		for (i = 0; i < MAX_RETRY; i++) {
			if (checkpasswd()) {
				return (0);
			}
			else {
				newpasswd();
			}
		}
		fprintf(stderr, "%s: Can't write to %s\n", progname, authDEV);
		return (-1);
	}

	if (checkpasswd()) {
		printf("%s", user);
		newpasswd();
		return (0);
	}

	return (-1);
}
