/*
 * Decompiled with CFR 0.152.
 */
package saccubus.net;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class Path
extends File {
    static final long serialVersionUID = 1L;

    public Path(String path) {
        super(path);
    }

    public Path(File file) {
        super(file.getAbsolutePath());
    }

    public Path(File dir, String name) {
        super(dir, name);
    }

    public Path(Path dirPath, String name) {
        super(dirPath, name);
    }

    public static String getName(String name) {
        Path path = new Path(name);
        return path.getName();
    }

    public static String GetFileName(String fullname) {
        return Path.getName(fullname);
    }

    public String getFullName() {
        return this.getAbsolutePath();
    }

    @Override
    public String getParent() {
        return super.getParent();
    }

    public Path getParentPath() {
        return new Path(this.getParent());
    }

    public static String[] GetFiles(String dir) {
        Path path = new Path(dir);
        String[] lists = path.list();
        int l = lists.length;
        String[] fulls = new String[l];
        int i = 0;
        while (i < l) {
            fulls[i] = new Path(path, lists[i]).getFullName();
            ++i;
        }
        return fulls;
    }

    public static boolean Exists(String name) {
        Path path = new Path(name);
        return path.exists();
    }

    public Path[] listPath() {
        String[] lists = this.list();
        int l = lists.length;
        Path[] paths = new Path[l];
        int i = 0;
        while (i < l) {
            paths[i] = new Path(this, lists[i]);
            ++i;
        }
        return paths;
    }

    public static String[] list(String dir) {
        Path path = new Path(dir);
        return path.list();
    }

    public static String[] list(Path path) {
        return path.list();
    }

    public static Path[] listPath(String dir) {
        Path path = new Path(dir);
        return path.listPath();
    }

    public static boolean isDirectory(String str) {
        Path path = new Path(str);
        return path.isDirectory();
    }

    public static boolean isFile(String str) {
        Path path = new Path(str);
        return path.isFile();
    }

    public String search(String name) {
        Path[] childs;
        Path[] pathArray = childs = this.listPath();
        int n = childs.length;
        int n2 = 0;
        while (n2 < n) {
            Path p = pathArray[n2];
            if (p.getName().equals(name)) {
                return p.getAbsolutePath();
            }
            ++n2;
        }
        return "";
    }

    public static String search(String dir, String name) {
        Path dirPath = new Path(dir);
        return dirPath.search(name);
    }

    public static String searchFile(String dir, String name) {
        String[] childs;
        File dirFile = new File(dir);
        String[] stringArray = childs = dirFile.list();
        int n = childs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals(name)) {
                return String.valueOf(dir) + File.separator + name;
            }
            ++n2;
        }
        return "";
    }

    public int indexOf(String str) {
        String name = this.getName();
        return name.indexOf(str);
    }

    public boolean contains(String str) {
        return this.indexOf(str) >= 0;
    }

    public String searchContains(String key) {
        String[] childs;
        String[] stringArray = childs = this.list();
        int n = childs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.indexOf(key) >= 0) {
                return new Path(this, s).getFullName();
            }
            ++n2;
        }
        return "";
    }

    public static String searchContains(String dir, String key) {
        Path path = new Path(dir);
        return path.searchContains(key);
    }

    public static String ReadAllText(String file, String encoding) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
            StringBuffer sb = new StringBuffer();
            String str = null;
            while ((str = br.readLine()) != null) {
                sb.append(String.valueOf(str) + "\n");
            }
            String string = sb.substring(0);
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String SearchFile(String string, String app_dir) {
        return Path.search(app_dir, string);
    }
}

