/*
 * Decompiled with CFR 0.152.
 */
package saccubus.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JTextField;

public class FileDropTarget
extends DropTargetAdapter {
    private final JTextField Field;
    private final boolean isFolder;

    public FileDropTarget(JTextField field, boolean is_folder) {
        this.isFolder = is_folder;
        this.Field = field;
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            dtde.acceptDrag(1);
            return;
        }
        dtde.rejectDrag();
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(1);
                Transferable t = dtde.getTransferable();
                List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                for (Object o : list) {
                    if (!(o instanceof File)) continue;
                    File file = (File)o;
                    if (this.isFolder) {
                        if (file.isDirectory()) {
                            this.Field.setText(file.getPath());
                            continue;
                        }
                        this.Field.setText(file.getParent());
                        continue;
                    }
                    if (!file.isFile()) continue;
                    this.Field.setText(file.getPath());
                }
                dtde.dropComplete(true);
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

