/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit;

import java.util.ArrayList;
import org.dbunit.Assertion;
import org.dbunit.DBTestCase;
import org.dbunit.DatabaseUnitException;
import org.dbunit.IDatabaseTester;
import org.dbunit.PrepAndExpectedTestCase;
import org.dbunit.VerifyTableDefinition;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.SortedTable;
import org.dbunit.dataset.filter.DefaultColumnFilter;
import org.dbunit.util.fileloader.DataFileLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPrepAndExpectedTestCase
extends DBTestCase
implements PrepAndExpectedTestCase {
    private final Logger LOG = LoggerFactory.getLogger((Class)DefaultPrepAndExpectedTestCase.class);
    private IDatabaseTester databaseTester;
    private DataFileLoader dataFileLoader;
    private IDataSet prepDs;
    private IDataSet expectedDs;
    private VerifyTableDefinition[] tableDefs;

    public DefaultPrepAndExpectedTestCase() {
    }

    public DefaultPrepAndExpectedTestCase(DataFileLoader dataFileLoader, IDatabaseTester databaseTester) {
        this.dataFileLoader = dataFileLoader;
        this.databaseTester = databaseTester;
    }

    public DefaultPrepAndExpectedTestCase(String name) {
        super(name);
    }

    public IDatabaseTester newDatabaseTester() throws Exception {
        return this.databaseTester;
    }

    public IDataSet getDataSet() throws Exception {
        return this.prepDs;
    }

    public void configureTest(VerifyTableDefinition[] tables, String[] prepDataFiles, String[] expectedDataFiles) throws Exception {
        this.LOG.debug("configureTest: saving instance variables");
        this.prepDs = this.makeCompositeDataSet(prepDataFiles);
        this.expectedDs = this.makeCompositeDataSet(expectedDataFiles);
        this.tableDefs = tables;
    }

    public void preTest() throws Exception {
        this.setupData();
    }

    public void preTest(VerifyTableDefinition[] tables, String[] prepDataFiles, String[] expectedDataFiles) throws Exception {
        this.configureTest(tables, prepDataFiles, expectedDataFiles);
        this.preTest();
    }

    public void postTest() throws Exception {
        this.postTest(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postTest(boolean verifyData) throws Exception {
        try {
            if (verifyData) {
                this.verifyData();
            }
        }
        finally {
            this.cleanupData();
        }
    }

    public void cleanupData() throws Exception {
        CompositeDataSet dataset = new CompositeDataSet(this.prepDs, this.expectedDs);
        String[] tableNames = dataset.getTableNames();
        int count = tableNames.length;
        this.LOG.info("cleanupData: about to clean up {} tables={}", (Object)new Integer(count), (Object)tableNames);
        if (this.databaseTester == null) {
            throw new IllegalStateException("databaseTester is null; must configure or set it first");
        }
        this.databaseTester.setDataSet(dataset);
        this.databaseTester.onTearDown();
        this.LOG.debug("cleanupData: Clean up done");
    }

    public void setupData() throws Exception {
        this.LOG.debug("setupData: setting prep dataset and inserting rows");
        if (this.databaseTester == null) {
            throw new IllegalStateException("databaseTester is null; must configure or set it first");
        }
        this.databaseTester.setDataSet(this.prepDs);
        this.databaseTester.onSetup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyData() throws Exception {
        if (this.databaseTester == null) {
            throw new IllegalStateException("databaseTester is null; must configure or set it first");
        }
        IDatabaseConnection connection = this.databaseTester.getConnection();
        try {
            int count = this.tableDefs.length;
            this.LOG.info("verifyData: about to verify {} tables={}", (Object)new Integer(count), (Object)this.tableDefs);
            if (count == 0) {
                this.LOG.warn("verifyData: No tables to verify; no VerifyTableDefinitions specified");
            }
            for (int i = 0; i < count; ++i) {
                VerifyTableDefinition td = this.tableDefs[i];
                String[] excludeColumns = td.getColumnExclusionFilters();
                String[] includeColumns = td.getColumnInclusionFilters();
                String tableName = td.getTableName();
                this.LOG.info("verifyData: Verifying table '{}'", (Object)tableName);
                this.LOG.debug("verifyData: Loading its rows from expected dataset");
                ITable expectedTable = null;
                try {
                    expectedTable = this.expectedDs.getTable(tableName);
                }
                catch (Exception e) {
                    String msg = "verifyData: Problem obtaining table '" + tableName + "' from expected dataset";
                    this.LOG.error(msg, (Throwable)e);
                    throw new DataSetException(msg, e);
                }
                this.LOG.debug("verifyData: Loading its rows from actual table");
                ITable actualTable = null;
                try {
                    actualTable = connection.createTable(tableName);
                }
                catch (Exception e) {
                    String msg = "verifyData: Problem obtaining table '" + tableName + "' from actual dataset";
                    this.LOG.error(msg, (Throwable)e);
                    throw new DataSetException(msg, e);
                }
                this.verifyData(expectedTable, actualTable, excludeColumns, includeColumns);
            }
        }
        finally {
            this.LOG.debug("verifyData: Verification done, closing connection");
            connection.close();
        }
    }

    public void verifyData(ITable expectedTable, ITable actualTable, String[] excludeColumns, String[] includeColumns) throws DatabaseUnitException {
        String method = "verifyData: ";
        this.LOG.debug("verifyData: Applying filters to expected table");
        ITable expectedFilteredTable = this.applyColumnFilters(expectedTable, excludeColumns, includeColumns);
        this.LOG.debug("verifyData: Applying filters to actual table");
        ITable actualFilteredTable = this.applyColumnFilters(actualTable, excludeColumns, includeColumns);
        this.LOG.debug("verifyData: Sorting expected table");
        SortedTable expectedSortedTable = new SortedTable(expectedFilteredTable);
        this.LOG.debug("verifyData: Sorted expected table={}", (Object)expectedSortedTable);
        this.LOG.debug("verifyData: Sorting actual table");
        SortedTable actualSortedTable = new SortedTable(actualFilteredTable, expectedFilteredTable.getTableMetaData());
        this.LOG.debug("verifyData: Sorted actual table={}", (Object)actualSortedTable);
        this.LOG.debug("verifyData: Comparing expected table to actual table");
        Column[] additionalColumnInfo = expectedTable.getTableMetaData().getColumns();
        Assertion.assertEquals((ITable)expectedSortedTable, (ITable)actualSortedTable, additionalColumnInfo);
    }

    public IDataSet makeCompositeDataSet(String[] dataFiles) throws DataSetException {
        if (this.dataFileLoader == null) {
            throw new IllegalStateException("dataFileLoader is null; must configure or set it first");
        }
        int count = dataFiles.length;
        this.LOG.debug("makeCompositeDataSet: dataFiles count=" + count);
        if (count == 0) {
            this.LOG.info("makeCompositeDataSet: Specified zero data files");
        }
        ArrayList<IDataSet> list = new ArrayList<IDataSet>();
        for (int i = 0; i < count; ++i) {
            IDataSet ds = this.dataFileLoader.load(dataFiles[i]);
            list.add(ds);
        }
        IDataSet[] dataSet = list.toArray(new IDataSet[0]);
        CompositeDataSet compositeDS = new CompositeDataSet(dataSet);
        return compositeDS;
    }

    public ITable applyColumnFilters(ITable table, String[] excludeColumns, String[] includeColumns) throws DataSetException {
        ITable filteredTable = table;
        if (table == null) {
            throw new IllegalArgumentException("table is null");
        }
        if (includeColumns == null) {
            this.LOG.debug("applyColumnFilters: including columns=(all)");
        } else {
            this.LOG.debug("applyColumnFilters: including columns='{}'", new Object[]{includeColumns});
            filteredTable = DefaultColumnFilter.includedColumnsTable(filteredTable, includeColumns);
        }
        if (excludeColumns == null || excludeColumns.length == 0) {
            this.LOG.debug("applyColumnFilters: excluding columns=(none)");
        } else {
            this.LOG.debug("applyColumnFilters: excluding columns='{}'", new Object[]{excludeColumns});
            filteredTable = DefaultColumnFilter.excludedColumnsTable(filteredTable, excludeColumns);
        }
        return filteredTable;
    }

    public IDataSet getPrepDataset() {
        return this.prepDs;
    }

    public IDataSet getExpectedDataset() {
        return this.expectedDs;
    }

    public IDatabaseTester getDatabaseTester() {
        return this.databaseTester;
    }

    public void setDatabaseTester(IDatabaseTester databaseTester) {
        this.databaseTester = databaseTester;
    }

    public DataFileLoader getDataFileLoader() {
        return this.dataFileLoader;
    }

    public void setDataFileLoader(DataFileLoader dataFileLoader) {
        this.dataFileLoader = dataFileLoader;
    }

    public void setPrepDs(IDataSet prepDs) {
        this.prepDs = prepDs;
    }

    public void setExpectedDs(IDataSet expectedDs) {
        this.expectedDs = expectedDs;
    }

    public VerifyTableDefinition[] getTableDefs() {
        return this.tableDefs;
    }

    public void setTableDefs(VerifyTableDefinition[] tableDefs) {
        this.tableDefs = tableDefs;
    }
}

