#pragma once

#include "Mix/Plugin/Sound/Decoder.h"
#include "vorbis/vorbisfile.h"

class Decoder : public Mix::Plugin::Sound::IDecoder
{
public:
	static const unsigned int CheckSize;

private:
	enum VALUE
	{
		CONVBUFFER_SIZE			= 4096,			//!< ϊobt@TCY
		BITSPERSAMPLE			= 16,			//!< rbg[g
	};

public:
	static Decoder* CreateInstance( void );

private:
	bool					m_bInitialized;
	WAVEFORMATEX			m_Format;
	OggVorbis_File			m_OVFile;
	unsigned long long		m_WavChannelSize;
	unsigned long long		m_WavSize;

private:
	Decoder( void );
	virtual ~Decoder( void );

	static size_t OVRead( void* buffer, size_t size, size_t maxCount, void* stream );
	static int OVSeek( void* buffer, ogg_int64_t offset, int flag );
	static long OVTell( void* buffer );
	static int OVClose( void* buffer );

public:

public:
	virtual bool Initialize( Mix::Plugin::IReader* pSrc );
	virtual void Destroy( void );
	virtual void Reset( Mix::Plugin::IReader* pSrc );
	virtual unsigned int Read( Mix::Plugin::IReader* pSrc, void* pDst, unsigned int size );
	virtual unsigned long long GetPosition( void );
	virtual unsigned long long GetSize( void );
	virtual LPCWAVEFORMATEX GetFormat( void );
};
