#include "Decoder.h"

static Mix::Plugin::INFORMATION g_Info = { Mix::Plugin::SOUND_DECODER, L"OggVorbis", L"1.0.0.0" };

const Mix::Plugin::INFORMATION& GetInformation( void )
{
	return g_Info;
}

bool __stdcall CheckFormat( const void* pData, unsigned int& size )
{
	if( pData == NULL )
	{
		//`FbN̂ɕKvȃTCYԂ
		size = Decoder::CheckSize;
	}
	else
	{
		if( Decoder::CheckSize <= size )
		{
			const unsigned char* key = static_cast<const unsigned char*>( pData );

			//wb_`FbN( OggS )
			if( ( key[0] != 0x4F ) ||
				( key[1] != 0x67 ) ||
				( key[2] != 0x67 ) ||
				( key[3] != 0x53 ) )
			{
				return false;
			}
		}
		else
		{
			return false;
		}
	}

	return true;
}

bool __stdcall CreateDecoder( Mix::Plugin::Sound::IDecoder** ppDecoder )
{
	Decoder* pDecoder;
	
	pDecoder = Decoder::CreateInstance();
	if( pDecoder == NULL )
	{
		return false;
	}

	( *ppDecoder ) = pDecoder;

	return true;
}