#include "Decoder.h"

////////////////////////////////////////////////////////////////////////////////////////////////////
// 萔
////////////////////////////////////////////////////////////////////////////////////////////////////

const unsigned int Decoder::CheckSize = 4;

////////////////////////////////////////////////////////////////////////////////////////////////////
// NX
////////////////////////////////////////////////////////////////////////////////////////////////////

Decoder* Decoder::CreateInstance( void )
{
	return new Decoder();
}

Decoder::Decoder( void ) :
m_Head( 0 ),
m_Size( 0 ),
m_Offset( 0 )
{
	::ZeroMemory( &m_Format, sizeof( m_Format ) );
}

Decoder::~Decoder( void )
{
}

bool Decoder::Initialize( Mix::Plugin::IReader* pSrc )
{
	const unsigned char FLAG_RIFF = 0x01;
	const unsigned char FLAG_WAVE = 0x02;
	const unsigned char FLAG_FMT  = 0x04;
	const unsigned char FLAG_DATA = 0x08;
	const unsigned char FLAG_ALL  = 0x0F;

	unsigned char flags = 0;

	for( ;; )
	{
		char name[5] = "";

		if( pSrc->Read( name, 4 ) == 4 )
		{
			if( ::strcmp( name, "RIFF" ) == 0 )
			{
				////////////////////////////////////////////////////////////////////////////////////////////////////
				// RIFF
				////////////////////////////////////////////////////////////////////////////////////////////////////

				if( ( flags & FLAG_RIFF ) != FLAG_RIFF )
				{
					unsigned int size = 0;

					if( pSrc->Read( &size, sizeof( size ) ) == sizeof( size ) )
					{
						flags |= FLAG_RIFF;
					}
					else
					{
						break;
					}
				}
				else
				{
					break;
				}
			}
			else if( ::strcmp( name, "WAVE" ) == 0 )
			{
				////////////////////////////////////////////////////////////////////////////////////////////////////
				// WAVE
				////////////////////////////////////////////////////////////////////////////////////////////////////

				if( ( flags & FLAG_WAVE ) != FLAG_WAVE )
				{
					flags |= FLAG_WAVE;
				}
				else
				{
					break;
				}
			}
			else if( ::strcmp( name, "fmt " ) == 0 )
			{
				////////////////////////////////////////////////////////////////////////////////////////////////////
				// fmt
				////////////////////////////////////////////////////////////////////////////////////////////////////

				if( ( flags & FLAG_FMT ) != FLAG_FMT )
				{
					unsigned int chuncSize = 0;

					if( pSrc->Read( &chuncSize, sizeof( chuncSize ) ) != sizeof( chuncSize ) )
					{
						break;
					}

					if( pSrc->Read( &m_Format, ( sizeof( WAVEFORMATEX ) - 2 ) ) != ( sizeof( WAVEFORMATEX ) - 2 ) )
					{
						break;
					}

					if( m_Format.wFormatTag != 0x0001 )
					{
						break;
					}

					flags |= FLAG_FMT;
				}
				else
				{
					break;
				}
			}
			else if( ::strcmp( name, "data" ) == 0 )
			{
				////////////////////////////////////////////////////////////////////////////////////////////////////
				// data
				////////////////////////////////////////////////////////////////////////////////////////////////////

				if( ( flags & FLAG_DATA ) != FLAG_DATA )
				{
					unsigned int waveSize = 0;

					if( pSrc->Read( &waveSize, sizeof( waveSize ) ) != sizeof( waveSize ) )
					{
						break;
					}

					m_Head = pSrc->GetPosition();
					m_Size = waveSize;

					flags |= FLAG_DATA;

					break;
				}
				else
				{
					break;
				}
			}
			else
			{
				break;
			}
		}
		else
		{
			break;
		}
	}

	return ( flags == FLAG_ALL );
}

void Decoder::Destroy( void )
{
	delete this;
}

LPCWAVEFORMATEX Decoder::GetFormat( void )
{
	return &m_Format;
}

unsigned long long Decoder::GetPosition( void )
{
	return m_Offset;
}

unsigned long long Decoder::GetSize( void )
{
	return m_Size;
}

void Decoder::Reset( Mix::Plugin::IReader* pSrc )
{
	pSrc->Seek( Mix::Plugin::IReader::BEGIN, m_Head );
	m_Offset = 0;
}

unsigned int Decoder::Read( Mix::Plugin::IReader* pSrc, void* pDst, unsigned int size )
{
	unsigned int readSize;
	unsigned int readedSize;

	if( m_Size < ( m_Offset + size ) )
	{
		readSize = static_cast<unsigned int>( ( m_Size - m_Offset ) );
	}
	else
	{
		readSize = size;
	}

	if( readSize > 0 )
	{
		readedSize = pSrc->Read( pDst, readSize );
	}
	else
	{
		readedSize = 0;
	}

	m_Offset += readedSize;

	return readedSize;
}
