#pragma once

#include "Mix/Plugin/Sound/Decoder.h"

class Decoder : public Mix::Plugin::Sound::IDecoder
{
public:
	static const unsigned int CheckSize;

public:
	static Decoder* CreateInstance( void );

private:
	WAVEFORMATEX m_Format;
	unsigned long long m_Head;
	unsigned long long m_Size;
	unsigned long long m_Offset;

private:
	Decoder( void );
	virtual ~Decoder( void );

public:
	virtual bool Initialize( Mix::Plugin::IReader* pSrc );
	virtual void Destroy( void );

	virtual LPCWAVEFORMATEX GetFormat( void );
	virtual unsigned long long GetPosition( void );
	virtual unsigned long long GetSize( void );

	virtual void Reset( Mix::Plugin::IReader* pSrc );
	virtual unsigned int Read( Mix::Plugin::IReader* pSrc, void* pDst, unsigned int size );
};
