#include "Decoder.h"

static Mix::Plugin::INFORMATION g_Info = { Mix::Plugin::SOUND_DECODER, L"Wave", L"1.0.0.0" };

const Mix::Plugin::INFORMATION& GetInformation( void )
{
	return g_Info;
}

bool __stdcall CheckFormat( const void* pData, unsigned int& size )
{
	if( pData == NULL )
	{
		size = Decoder::CheckSize;
	}
	else
	{
		if( Decoder::CheckSize <= size )
		{
			const char* pKey = static_cast<const char*>( pData );
			if( ( pKey[0] != 'R' ) ||
				( pKey[1] != 'I' ) ||
				( pKey[2] != 'F' ) ||
				( pKey[3] != 'F' ) )
			{
				return false;
			}
		}
		else
		{
			return false;
		}
	}

	return true;
}

bool __stdcall CreateDecoder( Mix::Plugin::Sound::IDecoder** ppDecoder )
{
	Decoder* pDecoder;

	pDecoder = Decoder::CreateInstance();
	if( pDecoder == NULL )
	{
		return false;
	}

	( *ppDecoder ) = pDecoder;

	return true;
}