#pragma once

//! @file Mix/Dynamics/IHingeJoint.h
//! @brief qWWCgC^[tF[XCN[ht@C

#include "Mix/Dynamics/IJoint.h"

namespace Mix{ namespace Dynamics{

	//! @class IHingeJoint
	//! @brief qWWCgC^[tF[X
	//! @note Wbh{fB𒱔(傤)ōS܂B
	class IHingeJoint : public Mix::Dynamics::IJoint
	{
	protected:
		//! @brief fXgN^
		virtual ~IHingeJoint( void ){}

	public:
		//! @brief ]擾܂
		//! @return ]\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetAxis( void ) const = 0;
		//! @brief ]ݒ肵܂
		//! @param[in] axis ]\ Mix::Vector3 NX
		virtual void SetAxis( const Mix::Vector3& axis ) = 0;

		//! @brief ]̍ŏpx擾܂
		//! @return ]̍ŏpxԂ܂
		virtual Float32 GetLowerLimit( void ) const = 0;
		//! @brief ]̍ŏpxݒ肵܂
		//! @param[in] limit ŏpx( WAP )
		virtual void SetLowerLimit( Float32 limit ) = 0;

		//! @brief ]̍őpx擾܂
		//! @return ]̍őpxԂ܂
		virtual Float32 GetUpperLimit( void ) const = 0;
		//! @brief ]̍őpxݒ肵܂
		//! @param[in] limit őpx( WAP )
		virtual void SetUpperLimit( Float32 limit ) = 0;

		//! @brief [^[Lǂ擾܂
		//! @return Lȏꍇ True Ԃ܂
		virtual Boolean GetMotorEnabled( void ) const = 0;
		//! @brief [^[Lɂ邩ǂݒ肵܂
		//! @param[in] state Lɂꍇ True
		virtual void SetMotorEnabled( Boolean state ) = 0;
		//! @brief [^[̃p[^ݒ肵܂
		//! @param[in] velocity ]x
		//! @param[in] maxImpulse ő匂
		virtual void SetMotorParams( Float32 velocity, Float32 maxImpulse ) = 0;
		//! @brief [^[̃p[^ݒ肵܂
		//! @param[in] angle ]x( WAP )
		//! @param[in] dt f^^C
		//! @param[in] maxImpulse ő匂
		virtual void SetMotorParams( Float32 angle, Float32 dt, Float32 maxImpulse ) = 0;
		//! @brief [^[̃p[^ݒ肵܂
		//! @param[in] ab ]x\ Mix::Quaternion NX
		//! @param[in] dt f^^C
		//! @param[in] maxImpulse ő匂
		virtual void SetMotorParams( const Mix::Quaternion& ab, Float32 dt, Float32 maxImpulse ) = 0;

		//! @brief ~bg̃XvÔ炩擾܂
		//! @return 炩Ԃ܂
		virtual Float32 GetLimitSpring( void ) const = 0;
		//! @brief ~bg̃XvÔ炩ݒ肵܂
		//! @param[in] spring 炩( 0.0f`1.0f )
		virtual void SetLimitSpring( Float32 spring ) = 0;

		//! @brief ~bg̃_p[̌͂擾܂
		//! @return ͂Ԃ܂
		virtual Float32 GetLimitDamper( void ) const = 0;
		//! @brief ~bg̃_p[̌͂ݒ肵܂
		//! @param[in] damper ( 0.2f`0.8f )
		virtual void SetLimitDamper( Float32 damper ) = 0;

		//! @brief [^[̐̃XvÔ炩擾܂
		//! @return 炩Ԃ܂
		virtual Float32 GetNormalSpring( void ) const = 0;
		//! @brief [^[̐̃XvÔ炩ݒ肵܂
		//! @param[in] spring 炩( 0.0f`1.0f )
		virtual void SetNormalSpring( Float32 spring ) = 0;

		//! @brief ]̊px擾܂
		//! @return ]̊px( WAP )Ԃ܂
		virtual Float32 GetAngle( void ) const = 0;
	};

}}
