#pragma once

//! @file Mix/Dynamics/IWorld.h
//! @brief [hC^[tF[XCN[ht@C

#include "Mix/Reference.h"
#include "Mix/Dynamics/IObject.h"
#include "Mix/Dynamics/IJoint.h"

namespace Mix{ namespace Dynamics{

	//! @class IWorld
	//! @brief [hC^[tF[X
	class IWorld : public Mix::Reference
	{
	public:
		//! @class TestCallback
		//! @brief eXgR[obNNX
		class TestCallback
		{
		public:
			//! @brief fXgN^
			virtual ~TestCallback( void ) {}

		public:
			//! @brief IuWFNgqbgۂɌĂяo܂
			//! @param[in] pObject qbgIuWFNg\ Mix::Dynamics::IObject C^[tF[X̃|C^
			//! @return
			//! eXgꍇ True Ԃ܂<br>
			//! ܂eXgpꍇ False Ԃ܂<br>
			virtual Boolean OnHit( Mix::Dynamics::IObject* pObject ) = 0;
		};

		//! @class TestWithoutSelfCallback
		//! @brief eXgR[obNNX(gO)
		class TestWithoutSelfCallback : public Mix::Dynamics::IWorld::TestCallback
		{
		private:
			Mix::Dynamics::IObject* m_pSelfObject;

		public:
			//! @brief RXgN^
			//! @param[in] pSelfObject g\ Mix::Dynamics::IObject C^[tF[X̃|C^
			//! @note nIuWFNg̎QƂ͕ێ܂
			TestWithoutSelfCallback( Mix::Dynamics::IObject* pSelfObject ) :
			m_pSelfObject( NULL )
			{
				MIX_ASSERT( pSelfObject != NULL );

				MIX_ADD_REF( pSelfObject );
				m_pSelfObject = pSelfObject;
			}

			//! @brief fXgN^
			virtual ~TestWithoutSelfCallback( void )
			{
				MIX_RELEASE( m_pSelfObject );
			}

			//! @brief IuWFNgqbgۂɌĂяo܂
			//! @param[in] pObject qbgIuWFNg\ Mix::Dynamics::IObject C^[tF[X̃|C^
			//! @return gƂēnIuWFNgł͂Ȃꍇ True Ԃ܂
			virtual Boolean OnHit( Mix::Dynamics::IObject* pObject )
			{
				return ( m_pSelfObject != pObject );
			}
		};

		//! @struct TEST_RESULT
		//! @brief eXgʍ\
		struct TEST_RESULT
		{
			Mix::Dynamics::IObject* pObject;	//!< qbgIuWFNg\ Mix::Dynamics::IObject C^[tF[X̃|C^

			//! @brief qbgp[gCfbNX
			//! @note
			//! qbgIuWFNg Mix::Dynamics::IStaticMesh łꍇ́A<br>
			//! IuWFNg쐬ۂɓn Mix::Dynamics::MESH \̂̔z̃CfbNXɂȂ܂B<br>
			//! ȊȌꍇ́A -1 ɂȂ܂B
			Int32 partIndex;

			//! @brief qbg|SCfbNX
			//! @note
			//! qbgIuWFNg Mix::Dynamics::IStaticMesh łꍇ́A<br>
			//! IuWFNg쐬ۂɓn Mix::Dynamics::MESH \̂̔z partIndex Ŏw肳ꂽp[g̃|S̃CfbNXɂȂ܂B
			Int32 polygonIndex;	

			Mix::Vector3 worldPos;		//!< qbgʒũ[hW
			Mix::Vector3 worldNormal;	//!< qbgʒũ[h@
		};

	protected:
		//! @brief fXgN^
		virtual ~IWorld( void ){}

	public:
		//! @brief WCg݂Ă邩ǂ擾܂
		//! @param[in] pJoint WCg\ Mix::Dynamics::IJoint C^[tF[X̃|C^
		//! @return WCg݂Ăꍇ True Ԃ܂
		virtual Boolean ContainsJoint( Mix::Dynamics::IJoint* pJoint ) const = 0;
		//! @brief WCgǉ܂
		//! @param[in] pJoint WCg\ Mix::Dynamics::IJoint C^[tF[X̃|C^
		//! @param[in] bCollisionDisabled ڑĂ郊Wbh{fBm̏Փ˂𖳌ɂꍇ True
		//! @return ꍇ True Ԃ܂
		//! @note
		//! ǉɐꍇAWCg̎QƃJE^ +1 ܂B<br>
		//! <br>
		//! WCgɂĐڑĂ郊Wbh{fB[hɒǉĂKv܂B
		virtual Boolean AddJoint( Mix::Dynamics::IJoint* pJoint, Boolean bCollisionDisabled = False ) = 0;
		//! @brief WCg菜܂
		//! @param[in] pJoint WCg\ Mix::Dynamics::IJoint C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		//! @note 菜ɐꍇAWCg̎QƃJE^ -1 ܂
		virtual Boolean RemoveJoint( Mix::Dynamics::IJoint* pJoint ) = 0;
		//! @brief w肵WCg̐擾܂
		//! @param[in] type WCg̎ނ\ Mix::Dynamics::IJoint::TYPE 񋓒萔
		//! @return WCg̐Ԃ܂
		virtual UInt32 GetJointCount( Mix::Dynamics::IJoint::TYPE type ) const = 0;
		//! @brief WCg̐擾܂
		//! @return WCg̐Ԃ܂
		virtual UInt32 GetTotalJointCount( void ) const = 0;

		//! @brief IuWFNg݂Ă邩ǂ擾܂
		//! @param[in] pObject IuWFNg\ Mix::Dynamics::IObject C^[tF[X̃|C^
		//! @return IuWFNg݂Ăꍇ True Ԃ܂
		virtual Boolean ContainsObject( Mix::Dynamics::IObject* pObject ) const = 0;
		//! @brief IuWFNgǉ܂
		//! @param[in] pObject IuWFNg\ Mix::Dynamics::IObject C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		//! @note ǉɐꍇ pObject ̎QƃJE^ +1 ܂
		virtual Boolean AddObject( Mix::Dynamics::IObject* pObject ) = 0;
		//! @brief IuWFNg菜܂
		//! @param[in] pObject IuWFNg\ Mix::Dynamics::IObject C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		//! @note 菜ɐꍇAIuWFNg̎QƃJE^ -1 ܂
		virtual Boolean RemoveObject( Mix::Dynamics::IObject* pObject ) = 0;
		//! @brief w肵IuWFNg̐擾܂
		//! @param[in] type IuWFNg̎ނ\ Mix::Dynamics::IObject::TYPE 񋓒萔
		//! @return IuWFNg̐Ԃ܂
		virtual UInt32 GetObjectCount( Mix::Dynamics::IObject::TYPE type ) const = 0;
		//! @brief SẴIuWFNg̐擾܂
		//! @return IuWFNg̐Ԃ܂
		virtual UInt32 GetTotalObjectCount( void ) const = 0;

		//! @brief d͂擾܂
		//! @return d͂\ Mix::Vector3 NXԂ܂
		virtual const Mix::Vector3& GetGravity( void ) const = 0;
		//! @brief d͂ݒ肵܂
		//! @param[in] gravity d͂\ Mix::Vector3 NX
		virtual void SetGravity( const Mix::Vector3& gravity ) = 0;

		//! @brief Ԃɂ܂
		//! @return ԂɂłIuWFNg̐Ԃ܂
		virtual UInt32 Activate( void ) = 0;
		//! @brief 񊈓Ԃɂ܂
		//! @return 񊈓ԂɂłIuWFNg̐Ԃ܂
		virtual UInt32 Deactivate( Boolean bForce = False ) = 0;

		//! @brief XV܂
		//! @param[in] dt 1t[̏v
		//! @param[in] baseDt 1t[̌Œ̏v
		//! @note IuWFNgɐݒ肳Ă郊Xi[͂̃^C~OŌĂяo܂
		virtual void Update( Float32 dt, Float32 baseDt = 1.0f / 60.0f ) = 0;

		//! @brief ŃeXg܂
		//! @param[in] fromWorldPos ̊JnW\ Mix::Vector3 NX
		//! @param[in] toWorldPos ̏IW\ Mix::Vector3 NX
		//! @param[in] filterGroup ̃tB^[O[v
		//! @param[in] filterMask ̃tB^[}XN
		//! @param[in] pCallback R[obN\ Mix::Dynamics::IWorld::TestCallback NX̃|C^( NULL w\ )
		//! @param[out] result eXgʂ\ Mix::Dynamics::IWorld::TEST_RESULT \
		//! @return Ăꍇ True Ԃ܂
		virtual Boolean TestRay(	const Mix::Vector3& fromWorldPos,
									const Mix::Vector3& toWorldPos,
									UInt16 filterGroup,
									UInt16 filterMask,
									Mix::Dynamics::IWorld::TestCallback* pCallback,
									Mix::Dynamics::IWorld::TEST_RESULT& result ) = 0;

		//! @brief XEB[vŃeXg܂
		//! @param[in] pShape VFCv\ Mix::Dynamics::IShape C^[tF[X̃|C^
		//! @param[in] fromWorldPos XEB[v̊Jnʒu\  Mix::Vector3 NX
		//! @param[in] toWorldPos XEB[v̏Iʒu\  Mix::Vector3 NX
		//! @param[in] filterGroup XEB[ṽtB^[O[v
		//! @param[in] filterMask XEB[ṽtB^[̃}XN
		//! @param[in] pCallback R[obN\ Mix::Dynamics::IWorld::TestCallback NX̃|C^( NULL w\ )
		//! @param[out] result eXgʂ\ Mix::Dynamics::IWorld::TEST_RESULT \
		//! @return Ăꍇ True Ԃ܂
		virtual Boolean TestSweep(	Mix::Dynamics::IShape* pShape,
									const Mix::Vector3& fromWorldPos,
									const Mix::Vector3& toWorldPos,
									UInt16 filterGroup,
									UInt16 filterMask,
									Mix::Dynamics::IWorld::TestCallback* pCallback,
									Mix::Dynamics::IWorld::TEST_RESULT& result ) = 0;

	public:
		//! @brief fobO : vt@C擾܂
		//! @return vt@C\ Mix::Dynamics::DEBUG_WORLD_PROFILE \̂Ԃ܂
		virtual const Mix::Dynamics::DEBUG_WORLD_PROFILE& Debug_GetProfile( void ) const = 0;
		//! @brief fobO : `s܂
		//! @param[in] pPerspectiveRenderer fobO`p̃p[XyNeBu_[\ Mix::Graphics::Utility::IPerspectiveRenderer C^[tF[X̃|C^
		virtual void Debug_Draw( Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer ) = 0;
	};

}}
