#pragma once

//! @file Mix/Geometry/OBB.h
//! @brief OBBNXCN[ht@C

namespace Mix{ namespace Geometry{

	//! @class OBB
	//! @brief OBBNX
	class _MIX_DLL_API OBB
	{
	public:
		//! @enum AXIS
		//! @brief 񋓒萔
		enum AXIS
		{
			AXIS_X = 0,	//!< X
			AXIS_Y = 1,	//!< Y
			AXIS_Z = 2,	//!< Z
		};

	public:
		Mix::Vector3 center;	//!< SW
		Mix::Vector3 axis[3];	//!< XYZ
		Mix::Vector3 length;	//!< XYZ̔̒
		Mix::Vector3 points[8];	//!< OBB̊e_

	public:
		//! @brief RXgN^
		OBB( void );
		//! @brief RXgN^
		//! @param[in] c SW\ Mix::Vector3 NX
		//! @param[in] ax X\ Mix::Vector3 NX
		//! @param[in] ay Y\ Mix::Vector3 NX
		//! @param[in] az Z\ Mix::Vector3 NX
		//! @param[in] l XYZ̔̒\ Mix::Vector3 NX
		OBB( const Mix::Vector3& c, const Mix::Vector3& ax, const Mix::Vector3& ay, const Mix::Vector3& az, const Mix::Vector3& l );

	public:
		//! @brief ݒ肳ꂽuSWvuXYZvuXYZ̔̒vOBB̒_W(8)߂܂
		void ComputePoints( void );
	};

}}
