#pragma once

//! @file Mix/Geometry/Plane.h
//! @brief v[NXCN[ht@C

namespace Mix{ namespace Geometry{

	//! @class Plane
	//! @brief ʃNX
	class _MIX_DLL_API Plane
	{
	public:
		Mix::Vector3 normal;	//!< @
		Float32 d;				//!< @ƕʏ̓_̓

	public:
		//! @brief RXgN^
		Plane( void );
		//! @brief RXgN^
		//! @param[in] n @
		//! @param[in] nd @ƕʏ̓_̓
		Plane( const Mix::Vector3& n, Float32 nd );
		//! @brief RXgN^
		//! @param[in] p1 ʏ̓_1
		//! @param[in] p2 ʏ̓_2
		//! @param[in] p3 ʏ̓_3
		//! @note _͉EŎw肵Ă
		Plane( const Mix::Vector3& p1, const Mix::Vector3& p2, const Mix::Vector3& p3 );

		//! @brief K܂
		void Normalize( void );

	public:
		//! @brief ʂZo܂
		//! @param[in] p1 ʏ̓_1
		//! @param[in] p2 ʏ̓_2
		//! @param[in] p3 ʏ̓_3
		//! @param[out] plane Zoꂽʂ\ Mix::Geometry::Plane NX
		//! @note _͉EŎw肵Ă
		static void Compute( const Mix::Vector3& p1, const Mix::Vector3& p2, const Mix::Vector3& p3, Mix::Geometry::Plane& plane );
	};

}}
