#pragma once

//! @file Mix/Graphics/Utility/ICanvasRenderer.h
//! @brief LoX_[C^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Graphics{ namespace Utility{

	//! @class ICanvasRenderer
	//! @brief LoX_[C^[tF[X
	class ICanvasRenderer : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~ICanvasRenderer( void ){}

	public:
		//! @brief ݐݒ肳ĂtHg擾܂
		//! @param[out] ppFont 擾tHgn Mix::Graphics::Utility::IFont C^[tF[X̃|C^̃AhX
		//! @return 擾ɐꍇ True Ԃ܂
		virtual Boolean GetFont( Mix::Graphics::Utility::IFont** ppFont ) const = 0;
		//! @brief tHgݒ肵܂
		//! @param[in] pFont Mix::Graphics::Utility::IFont C^[tF[X̃|C^
		virtual void SetFont( Mix::Graphics::Utility::IFont* pFont ) = 0;

		//! @brief ݐݒ肳ĂJ[擾܂
		//! @return J[\ Mix::Vector4 NXԂ܂
		virtual const Mix::Vector4& GetColor( void ) const = 0;
		//! @brief J[ݒ肵܂
		//! @param[in] color J[\ Mix::Vector4 NX
		virtual void SetColor( const Mix::Vector4& color ) = 0;

		//! @brief uh^Cv擾܂
		//! @return uh^Cv\ Mix::Graphics::BLEND_TYPE 񋓒萔Ԃ܂
		virtual Mix::Graphics::BLEND_TYPE GetBlendType( void ) const = 0;
		//! @brief uh^Cvݒ肵܂
		//! @param[in] type uh^Cv\ Mix::Graphics::BLEND_TYPE 񋓒萔
		virtual void SetBlendType( Mix::Graphics::BLEND_TYPE type ) = 0;

		//! @brief ݐݒ肳Ăϊs擾܂
		//! @return s\ Mix::Matrix3x3 NXԂ܂
		virtual const Mix::Matrix3x3& GetMatrix( void ) const = 0;
		//! @brief ϊsݒ肵܂
		//! @param[in] mat s
		virtual void SetMatrix( const Mix::Matrix3x3& mat ) = 0;
		//! @brief ݂̕ϊsۑ܂
		//! @return X^bNɐς܂ĂO̕ϊs̐Ԃ܂
		virtual UInt32 PushMatrix( void ) = 0;
		//! @brief ݂̕ϊsj܂
		//! @return X^bNɐς܂ĂO̕ϊs̐Ԃ܂
		virtual UInt32 PopMatrix( void ) = 0;
		//! @brief X^bNɐς܂ĂSĂ̍sro܂
		//! @return ros̐Ԃ܂
		virtual UInt32 DrainMatrix( void ) = 0;

		//! @brief ݂̃Nbv擾܂
		//! @return Nbv\ Mix::Rectangle NXԂ܂
		virtual const Mix::Rectangle& GetClip( void ) const = 0;
		//! @brief Nbvݒ肵܂
		//! @param[in] x wW
		//! @param[in] y xW
		//! @param[in] width 
		//! @param[in] height 
		virtual void SetClip( Int32 x, Int32 y, Int32 width, Int32 height ) = 0;
		//! @brief Nbvݒ肵܂
		//! @param[in] rect Nbv\ Mix::RectangleF NX
		virtual void SetClip( const Mix::Rectangle& rect ) = 0;
		//! @brief ݂̃Nbvۑ܂
		//! @return X^bNɐς܂ĂÕNbv̐Ԃ܂
		virtual UInt32 PushClip( void ) = 0;
		//! @brief ݂̃Nbvj܂
		//! @return X^bNɐς܂ĂÕNbv̐Ԃ܂
		virtual UInt32 PopClip( void ) = 0;
		//! @brief X^bNɐς܂ĂSẴNbvro܂
		//! @return roNbv̐Ԃ܂
		virtual UInt32 DrainClip( void ) = 0;

		//! @brief Cǉ܂
		//! @param[in] p1 C1Ԗڂ̓_\ Mix::Vector2 NX
		//! @param[in] p2 C2Ԗڂ̓_\ Mix::Vector2 NX
		virtual void AddLine( const Mix::Vector2& p1, const Mix::Vector2& p2 ) = 0;
		//! @brief Cǉ܂
		//! @param[in] points C̓_\ Mix::Vector2 NX̔z
		//! @param[in] numPoints C̓_̐
		virtual void AddLines( const Mix::Vector2 points[], UInt16 numPoints ) = 0;

		//! @brief `ǉ܂
		//! @param[in] rect `\ Mix::RectangleF NX
		virtual void AddRectangle( const Mix::RectangleF& rect ) = 0;
		//! @brief p`ǉ܂
		//! @param[in] points p`̓_\ Mix::Vector2 NX̔z
		//! @param[in] numPoints p`̓_̐
		virtual void AddPolygon( const Mix::Vector2 points[], UInt16 numPoints ) = 0;

		//! @brief hԂ`ǉ܂
		//! @param[in] rect `\ Mix::RectangleF NX
		virtual void AddFillRectangle( const Mix::RectangleF& rect ) = 0;
		//! @brief hԂp`ǉ܂
		//! @param[in] points p`̓_\ Mix::Vector2 NX̔z
		//! @param[in] numPoints p`̓_̐
		virtual void AddFillPolygon( const Mix::Vector2 points[], UInt16 numPoints ) = 0;

		//! @brief C[Wǉ܂
		//! @param[in] pTexture C[W\ Mix::Graphics::ITexture C^[tF[X̃|C^
		//! @param[in] dx `̍wW
		//! @param[in] dy `̍xW
		//! @param[in] width `̕
		//! @param[in] height `̍
		//! @param[in] sx `挳̍wW
		//! @param[in] sy `挳̍xW
		virtual void AddImage( Mix::Graphics::ITexture* pTexture, Float32 dx, Float32 dy, Float32 width, Float32 height, Float32 sx, Float32 sy ) = 0;
		//! @brief C[Wǉ܂
		//! @param[in] pTexture C[W\ Mix::Graphics::ITexture C^[tF[X̃|C^
		//! @param[in] dst ``\ Mix::RectangleF NX
		//! @param[in] src `挳W\ Mix::Vector2 NX
		virtual void AddImage( Mix::Graphics::ITexture* pTexture, const Mix::RectangleF& dst, const Mix::Vector2& src ) = 0;
		//! @brief C[Wǉ܂
		//! @param[in] pTexture C[W\ Mix::Graphics::ITexture C^[tF[X̃|C^
		//! @param[in] dx `̍wW
		//! @param[in] dy `̍xW
		//! @param[in] dw `̕
		//! @param[in] dh `̍
		//! @param[in] sx `挳̍wW
		//! @param[in] sy `挳̍xW
		//! @param[in] sw `挳̕
		//! @param[in] sh `挳̍
		virtual void AddImage( Mix::Graphics::ITexture* pTexture, Float32 dx, Float32 dy, Float32 dw, Float32 dh, Float32 sx, Float32 sy, Float32 sw, Float32 sh ) = 0;
		//! @brief C[W`悵܂
		//! @param[in] pTexture `悷C[W\ Mix::Graphics::ITexture C^[tF[X̃|C^
		//! @param[in] dst ``\ Mix::RectangleF NX
		//! @param[in] src `挳` Mix::RectangleF NX
		virtual void AddImage( Mix::Graphics::ITexture* pTexture, const Mix::RectangleF& dst, const Mix::RectangleF& src ) = 0;

		//! @brief ǉ܂
		//! @param[in] x `XW
		//! @param[in] y `YW
		//! @param[in] pStr 
		virtual void AddString( Float32 x, Float32 y, const wchar_t* pStr ) = 0;
		//! @brief ǉ܂
		//! @param[in] pos `̍W\ Mix::Vector2 NX
		//! @param[in] pStr 
		virtual void AddString( const Mix::Vector2& pos, const wchar_t* pStr ) = 0;
		//! @brief ǉ܂
		//! @param[in] rect `̋`\ Mix::RectangleF NX
		//! @param[in] pStr 
		//! @param[in] flags tO\ Mix::Graphics::Utility::STRING_FLAGS 񋓒萔̑gݍ킹
		virtual void AddString( const Mix::RectangleF& rect, const wchar_t* pStr, UInt32 flags = 0 ) = 0;

		//! @brief LoX_[XV܂
		virtual void Update( void ) = 0;
		//! @brief LoX_[`悵܂
		virtual void Draw( void ) = 0;
	};

}}}
