#pragma once

//! @file Mix/Graphics/Utility/IFont.h
//! @brief tHgC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Graphics{ namespace Utility{

	//! @class IFont
	//! @brief tHgC^[tF[X
	class IFont : public Mix::Reference
	{
	public:
		//! @enum EFFECTS
		//! @brief ʗ񋓒萔
		enum EFFECTS
		{
			EF_ITALIC		= 0x00000001,	//!< Α
			EF_BORDERING	= 0x00000002,	//!< 
		};

		//! @struct GLYPH
		//! @brief Ot\
		struct GLYPH
		{
			const void* pImg;	//!< C[W|C^( ̃|C^͉Ă͂܂ )
			UInt16 cellWidth;	//!< Z̕
			UInt16 cellHeight;	//!< Z̍
			Int16 x;			//!< wW ( Z̍_Ƃ[JW )
			Int16 y;			//!< xW ( Z̍_Ƃ[JW )
			UInt16 width;		//!< 
			UInt16 height;		//!< 
		};

	protected:
		//! @brief fXgN^
		virtual ~IFont( void ){}

	public:
		//! @brief tHgOt擾܂
		//! @param[in] code LN^[R[h
		//! @param[out] glyph Otn Mix::Graphics::Utility::IFont::GLYPH \
		//! @return ꍇ True Ԃ܂
		virtual Boolean GetGlyph( wchar_t code, Mix::Graphics::Utility::IFont::GLYPH& glyph ) = 0;
		//! @brief ʂ擾܂
		//! @return ʂ\ Mix::Graphics::Utility::IFont::EFFECTS 񋓒萔̑gݍ킹
		virtual UInt32 GetEffects( void ) const = 0;
		//! @brief tHg̃TCY擾܂
		//! @return TCYԂ܂
		virtual UInt32 GetHeight( void ) const = 0;
		//! @brief tHg̑擾܂
		//! @return Ԃ܂
		virtual UInt32 GetWeight( void ) const = 0;
		//! @brief ̃TCY擾܂
		//! @return TCYԂ܂
		virtual UInt32 GetBorderSize( void ) const = 0;
	};

}}}
