#pragma once

//! @file "Mix/Graphics/Utility/ITargetTextureChain.h"
//! @brief ^[QbgeNX``FCC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Graphics{ namespace Utility{

	//! @class ITargetTextureChain
	//! @brief ^[QbgeNX``FCC^[tF[X
	class ITargetTextureChain : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~ITargetTextureChain( void ){}

	public:
		//! @brief ݂̃^[QbgeNX`̃|C^擾܂
		//! @return ݂̃^[QbgeNX`\ Mix::Graphics::ITexture C^[tF[X̃|C^
		virtual Mix::Graphics::ITexture* GetCurrentPtr( void ) const = 0;
		//! @brief ̃^[QbgeNX`̃|C^擾܂
		//! @return ̃^[QbgeNX`\ Mix::Graphics::ITexture C^[tF[X̃|C^
		virtual Mix::Graphics::ITexture* GetNextPtr( void ) const = 0;
		//! @brief ̃^[QbgeNX`̃|C^擾A݂Ǝ̃^[QbgeNX`ւ܂
		//! @return ̃^[QbgeNX`\ Mix::Graphics::ITexture C^[tF[X̃|C^
		virtual Mix::Graphics::ITexture* GetNextPtrAndFlip( void ) = 0;
		//! @brief ݂Ǝ̃^[QbgeNX`ւ܂
		virtual void Flip( void ) = 0;

		//! @brief ^[QbgeNX`̕擾܂
		//! @return ^[QbgeNX`̕Ԃ܂
		virtual UInt32 GetWidth( void ) const = 0;
		//! @brief ^[QbgeNX`̍擾܂
		//! @return ^[QbgeNX`̍Ԃ܂
		virtual UInt32 GetHeight( void ) const = 0;
	};

}}}
