#pragma once

//! @file Mix/HID/IMouse.h
//! @brief }XC^[tF[XCN[ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace HID{

	//! @class IMouse
	//! @brief }EXC^[tF[X
	class IMouse : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IMouse( void ){}

	public:
		//! @brief {^̏Ԃ擾܂
		//! @param[in] button {^̃CfbNX
		//! @return {^̏Ԃ\ Mix::HID::SWITCH_STATE 񋓒萔̑gݍ킹Ԃ܂
		virtual UInt32 GetButtonState( UInt32 button ) = 0;

		//! @brief zC[̏Ԃ擾܂
		//! @return Oɉ񂵂ꍇ͕̒lAɉ񂵂ꍇ͐̒lAԂ܂( -120 ` 120 )
		virtual Int32 GetWheelDelta( void ) = 0;

		//! @brief Wݒ肵܂
		//! @param[in] x XW
		//! @param[in] y YW
		virtual void SetPos( Int32 x, Int32 y ) = 0;
		//! @brief Wݒ肵܂
		//! @param[in] pos ݒ肷W\ Mix::Point NX
		virtual void SetPos( const Mix::Point& pos ) = 0;
		//! @brief W擾܂
		//! @return W\ Mix::Point NXԂ܂
		virtual const Mix::Point& GetPos( void ) const = 0;

		//! @brief ړx擾܂
		//! @return ړx\ Mix::Point NXԂ܂
		virtual const Mix::Point& GetVelocity( void ) const = 0;
		//! @brief XN[̍W擾܂
		//! @return XN[̍W\ Mix::Point NXԂ܂
		virtual const Mix::Point& GetScreenPos( void ) const = 0;
	};

}}

