#pragma once

/*!
@page intro_graphics_page Graphics
@section intro_graphics_textureLoader_sec TextureLoader

<ol type="1">
	<li><b>vWFNg̍쐬</b></li><br>
	Cj[́ut@CvuVK쐬vuvWFNgvIŁAuWin32 R\[AvP[Vv DLL̃vWFNg쐬܂B<br>
	ɃvWFNg̃vpeBJAu\vpeBvuC/C++vuSʁvɂuǉ̃CN[hfBNgv Mix ̃CN[ht@CfBNg()w肵܂B<br>
	<br>
	 "Mix\Engine\Include\"<br>

	<li><b>DLL GNX|[g̃\[Xt@C̍쐬</b></li><br>
	vWFNg <b>"main.cpp"</b> ǉAȉ̊֐܂B<br>
	<ul>
		<li><b>Mix::Plugin::INFORMATION __stdcall GetInformation ( void )</b></li><br>
		̃vOC̏擾֐łB<br>

		<li><b>Int32 __stdcall Load ( Mix::Plugin::IReader* pSrc, Mix::Plugin::Graphics::ITextureKit* pDst )</b></li><br>
		eNX`[h֐ł Mix::Plugin::Graphics::TEXTURE_PLUGIN_RESULT 񋓒萔̂ꂩԂKv܂B<br>
		<br>
		<ul>
			<li>\[X ( pSrc )</li><br>
			eNX`̌ɂȂf[^ɂȂ܂B<br>
			̃\[Xf[^ǂݎALbgɐݒAWJ܂B<br>
			<br>
			<li>Lbg ( pDst )</li><br>
			\[Xǂݎf[^eNX`ɂ钼O̍\ɂȂ܂B<br>
			Lbg͊{ݒƂāA<b>^CvAtH[}bgATCYA[xA~bvxAtO</b>܂B<br>
			́Aȉ̃\bhgpĐݒ肵܂B<br>
			<br>
			Mix::Plugin::Graphics::ITextureKit::SetType<br>
			Mix::Plugin::Graphics::ITextureKit::SetFormat<br>
			Mix::Plugin::Graphics::ITextureKit::SetSize<br>
			Mix::Plugin::Graphics::ITextureKit::SetDepth<br>
			Mix::Plugin::Graphics::ITextureKit::SetMipLevels<br>
			Mix::Plugin::Graphics::ITextureKit::SetFlags<br>
			<br>
			܂A^CvATCYA[xA~bvxAtOɂāAACAEgωA<b>Tu\[X</b>Ƃ̂܂B<br>
			Tu\[XƂ́ACC[WA~bv}bvC[WȂǂ̕Iȃ\[X̂ƂA<br>
			Mix::Plugin::Graphics::ITextureKit::AddSubResourceData \bhgpĒǉ܂B<br>
			Tu[X̃CAEgȉɒ񎦂܂B<br>
			<br>
			<ul>
				<li>Type = <b>PLANE</b> Size = <b>128x128</b> MipLevels = <b>8</b></li><br>
				v[eNX` MipLevels ̃Tu\[XKvƂA[x͖܂B<br>
				<br>
				<ul>
					<li>MipLevel = 1 Size = 128x128</li>
					<li>MipLevel = 2 Size = 64x64</li>
					<li>MipLevel = 3 Size = 32x32</li>
					<li>MipLevel = 4 Size = 16x16</li>
					<li>MipLevel = 5 Size = 8x8</li>
					<li>MipLevel = 6 Size = 4x4</li>
					<li>MipLevel = 7 Size = 2x2</li>
					<li>MipLevel = 8 Size = 1x1</li>
				</ul>
				<br>
				<li>Type = <b>VOLUME</b> Size = <b>64x64</b> MipLevels = <b>7</b> Depth ( Slice ) = <b>4</b></li><br>
				{[eNX` MipLevels ̃Tu\[XKvƂ܂B<br>
				܂ASlice ̓~bvxオɂĔɂȂĂ܂A0 ɂȂ邱Ƃ͂܂B<br>
				<br>
				<ul>
					<li>MipLevel = 1 Slice = 4</li>
					<ul>
						<li>Slice = 1/4 Size = 64x64</li>
						<li>Slice = 2/4 Size = 64x64</li>
						<li>Slice = 3/4 Size = 64x64</li>
						<li>Slice = 4/4 Size = 64x64</li>
					</ul>
					<li>MipLevel = 2 Slice = 2</li>
					<ul>
						<li>Slice = 1/2 Size = 32x32</li>
						<li>Slice = 2/2 Size = 32x32</li>
					</ul>
					<li>MipLevel = 3 Slice = 1</li>
					<ul>
						<li>Slice = 1/1 Size = 16x16</li>
					</ul>
					<li>MipLevel = 4 Slice = 1</li>
					<ul>
						<li>Slice = 1/1 Size = 8x8</li>
					</ul>
					<li>MipLevel = 5 Slice = 1</li>
					<ul>
						<li>Slice = 1/1 Size = 4x4</li>
					</ul>
					<li>MipLevel = 6 Slice = 1</li>
					<ul>
						<li>Slice = 1/1 Size = 2x2</li>
					</ul>
					<li>MipLevel = 7 Slice = 1</li>
					<ul>
						<li>Slice = 1/1 Size = 1x1</li>
					</ul>
				</ul>
				<br>
				<li>Type = <b>CUBE</b> Size = <b>256x256</b> MipLevels = <b>9</b></li><br>
				L[ueNX` 1 ` 6  * MipLevels ̃Tu\[XKvƂA[x͖܂B<br>
				܂Aʂ̏ Mix::Plugin::Graphics::ITextureKit::FLAG ɒ`Ă CUBE_??? ̕тƓɂȂA<br>
				Tu\[XƂĒǉʂ Mix::Plugin::Graphics::ITextureKit::SetFlags \bhŐݒ肵ĂKv܂B<br>
				ȉ̃CAEǵA6 ʑSẴtOݒ肵̂ɂȂ܂B<br>
				<br>
				<ul>
					<li>POSITIVEX ( ̂w )</li>
					<ul>
						<li>MipLevel = 1 Size = 256x256</li>
						<li>MipLevel = 2 Size = 128x128</li>
						<li>MipLevel = 3 Size = 64x64</li>
						<li>MipLevel = 4 Size = 32x32</li>
						<li>MipLevel = 5 Size = 16x16</li>
						<li>MipLevel = 6 Size = 8x8</li>
						<li>MipLevel = 7 Size = 4x4</li>
						<li>MipLevel = 8 Size = 2x2</li>
						<li>MipLevel = 9 Size = 1x1</li>
					</ul>
					<li>NEGATIVEX ( ̂w )</li>
					<ul>
						<li>MipLevel = 1 Size = 256x256</li>
						<li>MipLevel = 2 Size = 128x128</li>
						<li>MipLevel = 3 Size = 64x64</li>
						<li>MipLevel = 4 Size = 32x32</li>
						<li>MipLevel = 5 Size = 16x16</li>
						<li>MipLevel = 6 Size = 8x8</li>
						<li>MipLevel = 7 Size = 4x4</li>
						<li>MipLevel = 8 Size = 2x2</li>
						<li>MipLevel = 9 Size = 1x1</li>
					</ul>
					<li>POSITIVEY ( ̂x )</li>
					<ul>
						<li>MipLevel = 1 Size = 256x256</li>
						<li>MipLevel = 2 Size = 128x128</li>
						<li>MipLevel = 3 Size = 64x64</li>
						<li>MipLevel = 4 Size = 32x32</li>
						<li>MipLevel = 5 Size = 16x16</li>
						<li>MipLevel = 6 Size = 8x8</li>
						<li>MipLevel = 7 Size = 4x4</li>
						<li>MipLevel = 8 Size = 2x2</li>
						<li>MipLevel = 9 Size = 1x1</li>
					</ul>
					<li>NEGATIVEY ( ̂x )</li>
					<ul>
						<li>MipLevel = 1 Size = 256x256</li>
						<li>MipLevel = 2 Size = 128x128</li>
						<li>MipLevel = 3 Size = 64x64</li>
						<li>MipLevel = 4 Size = 32x32</li>
						<li>MipLevel = 5 Size = 16x16</li>
						<li>MipLevel = 6 Size = 8x8</li>
						<li>MipLevel = 7 Size = 4x4</li>
						<li>MipLevel = 8 Size = 2x2</li>
						<li>MipLevel = 9 Size = 1x1</li>
					</ul>
					<li>POSITIVEZ ( ̂y )</li>
					<ul>
						<li>MipLevel = 1 Size = 256x256</li>
						<li>MipLevel = 2 Size = 128x128</li>
						<li>MipLevel = 3 Size = 64x64</li>
						<li>MipLevel = 4 Size = 32x32</li>
						<li>MipLevel = 5 Size = 16x16</li>
						<li>MipLevel = 6 Size = 8x8</li>
						<li>MipLevel = 7 Size = 4x4</li>
						<li>MipLevel = 8 Size = 2x2</li>
						<li>MipLevel = 9 Size = 1x1</li>
					</ul>
					<li>NEGATIVEZ ( ̂y )</li>
					<ul>
						<li>MipLevel = 1 Size = 256x256</li>
						<li>MipLevel = 2 Size = 128x128</li>
						<li>MipLevel = 3 Size = 64x64</li>
						<li>MipLevel = 4 Size = 32x32</li>
						<li>MipLevel = 5 Size = 16x16</li>
						<li>MipLevel = 6 Size = 8x8</li>
						<li>MipLevel = 7 Size = 4x4</li>
						<li>MipLevel = 8 Size = 2x2</li>
						<li>MipLevel = 9 Size = 1x1</li>
					</ul>
				</ul>
			</ul>
		</ul>
	</ul>

	<li><b>DLL GNX|[g̃W[`t@C̍쐬</b></li><br>
	vWFNgɈȉ̃W[Lqt@C <b>"main.def"</b> ǉĂB<br>

	<pre><b>EXPORTS</b>
	<b>GetInformation</b>
	<b>Load</b></pre>
	
	ŌɃvWFNg̃vpeB́u\vpeBvuJvúvɂuW[`t@Cv "main.def" w肵ĂB

</ol>
*/

#include "Mix/Plugin/Common.h"
#include "Mix/Plugin/IReader.h"

namespace Mix{ namespace Plugin{ namespace Graphics{

	//! @enum TEXTURE_PLUGIN_RESULT
	//! @brief eNX`vOCUg񋓒萔
	enum TEXTURE_PLUGIN_RESULT
	{
		TP_NOT_SUPPORTED	= 1,	//!< T|[gĂȂ
		TP_OK				= 0,	//!< 
		TP_ILLEGAL_FORMAT	= -1,	//!< sȃtH[}bg( ps )
		TP_OUT_OF_MEMORY	= -2,	//!< VXes( ps )
		TP_FATAL_ERROR		= -3,	//!< vIȃG[
	};

	//! @class ITextureKit
	//! @brief eNX`LbgC^[tF[X
	class ITextureKit
	{
	public:
		//! @enum TYPE
		//! @brief ^Cv񋓒萔
		enum TYPE
		{
			PLANE	= 0,	//!< v[eNX`
			CUBE	= 1,	//!< L[ueNX`
			VOLUME	= 2,	//!< {[eNX`
		};

		//! @enum FLAG
		//! @brief tO񋓒萔
		enum FLAG
		{
			CUBE_POSITIVEX = 0x00000001,	//!< L[u̐̂w
			CUBE_NEGATIVEX = 0x00000002,	//!< L[û̕w
			CUBE_POSITIVEY = 0x00000004,	//!< L[u̐̂x
			CUBE_NEGATIVEY = 0x00000008,	//!< L[û̕x
			CUBE_POSITIVEZ = 0x00000010,	//!< L[u̐̂y
			CUBE_NEGATIVEZ = 0x00000020,	//!< L[û̕y
		};

		//! @enum FORMAT
		//! @brief tH[}bg񋓒萔
		enum FORMAT
		{
			R8G8B8A8	= 0,	//!< e`l 8Bit  RGBA tH[}bg

			BC1			= 1,	//!< BC1 tH[}bg
			BC2			= 2,	//!< BC2 tH[}bg
			BC3			= 3,	//!< BC3 tH[}bg
		};

	protected:
		//! @brief fXgN^
		virtual ~ITextureKit( void ) {}

	public:
		//! @brief ^Cvݒ肵܂
		//! @param[in] type ^Cv\ Mix::Plugin::Graphics::ITextureKit::TYPE 񋓒萔
		virtual void SetType( Mix::Plugin::Graphics::ITextureKit::TYPE type ) = 0;
		//! @brief tH[}bgݒ肵܂
		//! @param[in] format tH[}bg\ Mix::Plugin::Graphics::ITextureKit::FORMAT 񋓒萔
		virtual void SetFormat( Mix::Plugin::Graphics::ITextureKit::FORMAT format ) = 0;
		//! @brief TCYݒ肵܂
		//! @param[in] width 
		//! @param[in] height 
		virtual void SetSize( unsigned int width, unsigned int height ) = 0;
		//! @brief [xݒ肵܂
		//! @param[in] depth [x
		//! @note {[eNX`̃XCXɂȂ܂B
		virtual void SetDepth( unsigned int depth ) = 0;
		//! @brief ~bv}bv̐ݒ肵܂
		//! @param[in] mipLevels ~bv}bv̐
		virtual void SetMipLevels( unsigned int mipLevels ) = 0;
		//! @brief tOݒ肵܂
		//! @param[in] flags Mix::Plugin::Graphics::ITexture::FLAG 񋓒萔̑gݍ킹
		virtual void SetFlags( unsigned int flags ) = 0;

		//! @brief Tu\[Xǉ܂
		//! @param[in] memSize ̃TCY( oCgP )
		//! @param[in] memRowPitch ̈̃TCY( oCgP )
		//! @param[in] memSlicePitch ̃܂ł̋( oCgP )
		//! @return memSize mۂ̃|C^Ԃ܂B
		virtual void* AddSubResourceData( unsigned int memSize, unsigned int memRowPitch, unsigned int memSlicePitch = 0 ) = 0;
		//! @brief Tu\[Xǉ܂
		//! @param[in] pMem ̃|C^
		//! @param[in] memSize ̃TCY( oCgP )
		//! @param[in] memRowPitch ̈̃TCY( oCgP )
		//! @param[in] memSlicePitch ̃܂ł̋( oCgP )
		virtual void AddSubResourceData( const void* pMem, unsigned int memSize, unsigned int memRowPitch, unsigned int memSlicePitch = 0 ) = 0;
	};

}}}
