#pragma once

//! @file Mix/Plugin/IReader.h
//! @brief [_[C^[tF[XCN[ht@C

namespace Mix{ namespace Plugin{

	//! @class IReader
	//! @brief [_[C^[tF[X
	class IReader
	{
	public:
		//! @enum SEEK_METHOD
		//! @brief V[N\bh񋓒萔
		enum SEEK_METHOD
		{
			BEGIN	= 0,	//!< \[X̐擪I[ɌĈړ
			CURRENT	= 1,	//!< ݂̈ʒuړ
			END		= 2,	//!< \[X̏I[擪ɌĈړ
		};

	protected:
		//! @brief fXgN^
		virtual ~IReader( void ) {}

	public:
		//! @brief TCY擾܂
		//! @return TCYԂ܂
		virtual unsigned long long GetSize( void ) const = 0;
		//! @brief ǂݎʒu擾܂
		//! @return ǂݎʒuԂ܂
		virtual unsigned long long GetPosition( void ) const = 0;
		//! @brief obt@Ɏw肵TCYǂݎ܂
		//! @param[in] pBuffer ǂݎ̃obt@
		//! @param[in] readSize obt@ɓǂݍރTCY( oCgP )
		//! @return ۂɓǂݎTCYԂ܂
		virtual unsigned int Read( void* pBuffer, unsigned int readSize ) = 0;
		//! @brief w肵TCYǂݎ܂
		//! @param[in] readSize ǂݎTCY( oCgP )
		//! @param[out] result ۂɓǂݎTCY( oCgP )
		//! @return ǂݎJn郁̃|C^Ԃ܂
		virtual const void* Read( unsigned int readSize, unsigned int& result ) = 0;
		//! @brief ǂݎʒuړ܂
		//! @param[in] method ړ̊_\ Mix::Plugin::IReader::SEEK_METHOD 񋓒萔
		//! @param[in] distance _̈ړ( oCgP )
		//! @return ړ̓ǂݎʒuԂ܂B
		virtual unsigned long long Seek( Mix::Plugin::IReader::SEEK_METHOD method, unsigned long long distance ) = 0;
	};

}}