#pragma once

#include "Mix/Dynamics/IBoxShape.h"
#include "Mix/Private/Dynamics/Shape.h"

namespace Mix{ namespace Dynamics{

	class BoxShape : public Mix::Dynamics::IBoxShape, public Mix::Dynamics::Shape
	{
	public:
		static BoxShape* CreateInstance( const Mix::Vector3& size );

	private:
		Mix::Vector3 m_Size;
		btBoxShape* m_pObject;

	private:
		BoxShape( const Mix::Vector3& size );
		virtual ~BoxShape( void );

	public:
		Boolean Initialize( void );

	public:
		virtual btConvexShape* Bullet_GetConvexShapePtr( void ) const;

	public:
		virtual const Mix::Vector3& GetHalfExtents( void ) const;

	public:
		virtual Mix::Dynamics::IShape::TYPE GetType( void ) const;

		virtual Float32 GetMargin( void ) const;
		virtual void SetMargin( Float32 margin );

		virtual void DebugDraw( Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer );
	};

}}
