#pragma once

#include "Mix/Dynamics/ICompoundShape.h"
#include "Mix/Private/Dynamics/Shape.h"

namespace Mix{ namespace Dynamics{

	class CompoundShape : public Mix::Dynamics::ICompoundShape, public Mix::Dynamics::Shape
	{
	private:
		typedef Mix::STL::Vector<Mix::Memory::SECTION_SCENE, Mix::Dynamics::IShape*> ChildList;

	public:
		static CompoundShape* CreateInstance( void );

	private:
		btCompoundShape* m_pObject;
		CompoundShape::ChildList m_ChildList;

	private:
		CompoundShape( void );
		virtual ~CompoundShape( void );

	public:
		Boolean Initialize( void );

	public:
		virtual btConvexShape* Bullet_GetConvexShapePtr( void ) const;

	public:
		virtual Boolean AddChild( Mix::Dynamics::IShape* pShape, const Mix::Quaternion& rot, const Mix::Vector3& pos );
		virtual UInt32 RemoveChild( Mix::Dynamics::IShape* pShape );
		virtual Boolean RemoveChildByIndex( UInt32 index );

		virtual Boolean GetChildByIndex( UInt32 index, Mix::Dynamics::IShape** ppShape );
		virtual Mix::Dynamics::IShape* GetChildPtrByIndex( UInt32 index ) const;

		virtual Boolean GetChildTransformByIndex( UInt32 index, Mix::Quaternion& rot, Mix::Vector3& pos );
		virtual Boolean SetChildTransformByIndex( UInt32 index, const Mix::Quaternion& rot, const Mix::Vector3& pos );

		virtual UInt32 GetChildCount( void ) const;

	public:
		virtual Mix::Dynamics::IShape::TYPE GetType( void ) const;

		virtual Float32 GetMargin( void ) const;
		virtual void SetMargin( Float32 margin );

		virtual void DebugDraw( Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer );
	};

}}
