#pragma once

#include "Mix/Private/Dynamics/World.h"

namespace Mix{ namespace Dynamics{

	class ObjectContext;

	class Object
	{
	private:
		Mix::Dynamics::World* m_pWorld;

		UInt16 m_FilterGroup;
		UInt16 m_FilterMask;

	protected:
		UInt32 m_DebugDrawFlags;
		Float32 m_DebugDrawAxisScaling;

	protected:
		Object( UInt16 filterGroup, UInt16 filterMask, UInt32 debugDrawFlags );
		virtual ~Object( void );

		virtual void OnAttachToWorld( Mix::Dynamics::World* pWorld ) {}
		virtual void OnDetachFromWorld( Mix::Dynamics::World* pWorld ) {}

	public:
		Boolean IsInWorld( void ) const;
		Mix::Dynamics::World* GetWorldPtr( void ) const;
		void SetWorldPtr( Mix::Dynamics::World* pWorld );

		virtual Mix::Dynamics::ObjectContext* GetContextPtr( void ) const = 0;

		void Bullet_BeginRefresh( void );
		void Bullet_EndRefresh( void );

		void Bullet_Refresh( void );

		UInt16 Bullet_GetFilterGroup( void ) const;
		void Bullet_SetFilterGroup( UInt16 filterGroup );

		UInt16 Bullet_GetFilterMask( void ) const;
		void Bullet_SetFilterMask( UInt16 filterMask );

		virtual btCollisionObject* Bullet_GetCollisionObjectPtr( void ) const = 0;
		virtual btRigidBody* Bullet_GetRigidBodyPtr( void ) const;

		virtual btActionInterface* Bullet_GetActionInterfacePtr( void ) const;
		virtual btCharacterControllerInterface* Bullet_GetCharacterControllerInterfacePtr( void ) const;
		virtual btRaycastVehicle* Bullet_GetRaycastVehiclePtr( void ) const;
	};

}}
