#include "Mix/Private/Dynamics/Shape.h"

namespace Mix{ namespace Dynamics{

Shape::Shape( void ) :
m_pCollisionShape( NULL ),
m_BaseMargin( 0.0f ),
m_Margin( 0.0f )
{
}

Shape::~Shape( void )
{
}

void Shape::Bullet_SetCollisionShape( btCollisionShape* pCollisionShape )
{
	MIX_ASSERT( m_pCollisionShape == NULL );

	m_pCollisionShape = pCollisionShape;
	m_BaseMargin = m_pCollisionShape->getMargin();
}

btCollisionShape* Shape::Bullet_GetCollisionShapePtr( void ) const
{
	MIX_ASSERT( m_pCollisionShape != NULL );

	return m_pCollisionShape;
}

Float32 Shape::Bullet_GetMargin( void ) const
{
	return m_Margin;
}

void Shape::Bullet_SetMargin( Float32 margin )
{
	MIX_ASSERT( m_pCollisionShape );

	m_Margin = max( 0.0f, margin );
	m_pCollisionShape->setMargin( m_BaseMargin + m_Margin );
}

}}
