#include "Mix/Private/Dynamics/SphereShape.h"

#include "Mix/Graphics/Utility/IPerspectiveRenderer.h"

namespace Mix{ namespace Dynamics{

SphereShape* SphereShape::CreateInstance( void )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_DYNAMICS, SphereShape );
}

SphereShape::SphereShape( void ) :
m_pObject( NULL )
{
}

SphereShape::~SphereShape( void )
{
	MIX_LIB_DELETE( m_pObject );
}

Boolean SphereShape::Initialize( Float32 radius )
{
	m_pObject = MIX_LIB_NEW btSphereShape( radius );
	if( m_pObject != NULL )
	{
		Shape::Bullet_SetCollisionShape( m_pObject );
	}
	else
	{
		return False;
	}

	return True;
}

btConvexShape* SphereShape::Bullet_GetConvexShapePtr( void ) const
{
	return m_pObject;
}

Float32 SphereShape::GetRadius( void ) const
{
	return m_pObject->getRadius();
}

Mix::Dynamics::IShape::TYPE SphereShape::GetType( void ) const
{
	return Mix::Dynamics::IShape::SPHERE;
}

Float32 SphereShape::GetMargin( void ) const
{
	return Shape::Bullet_GetMargin();
}
void SphereShape::SetMargin( Float32 margin )
{
	Shape::Bullet_SetMargin( margin );
}

void SphereShape::DebugDraw( Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer )
{
	if( pPerspectiveRenderer != NULL )
	{
		pPerspectiveRenderer->AddSphere( GetRadius() );
	}
}

}}
