#pragma once

////////////////////////////////////////////////////////////////////////////////////////////////////
// [eBeB
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{ namespace Dynamics{

	Mix::Quaternion ToMixQuaternion( const btQuaternion& quat );
	Mix::Vector3 ToMixVector3( const btVector3& vec );
	Mix::Matrix4x4 ToMixMatrix4x4( const btTransform& tr );

	btQuaternion ToBulletQuaternion( const Mix::Quaternion& quat );
	btVector3 ToBulletVector3( const Mix::Vector3& vec );

}}

////////////////////////////////////////////////////////////////////////////////////////////////////
// [eBeB : fobO
////////////////////////////////////////////////////////////////////////////////////////////////////

namespace Mix{ namespace Dynamics{ namespace Debug{

	Mix::Vector4 GetColor( Mix::Dynamics::DEBUG_DRAW_COLOR_TYPE type, Float32 opacity );
	Mix::Vector4 GetRigidBodyColor( btRigidBody* pRigidBody, Float32 opacity );

	const Mix::Vector4& GetColor( Mix::Dynamics::DEBUG_DRAW_COLOR_TYPE type );
	void SetColor( Mix::Dynamics::DEBUG_DRAW_COLOR_TYPE type, const Mix::Vector4& color );

	void DrawPivot( Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer,
					const btTypedConstraint* pConstraint,
					const btVector3& pivtoA,
					const btVector3& pivotB,
					Float32 minSize = 0.01f );

	void DrawBox(	Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer,
					const btVector3& bbMin,
					const btVector3& bbMax );

	void DrawArc(	Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer,
					const btVector3& center,
					const btVector3& normal,
					const btVector3& axis,
					Float32 radiusA,
					Float32 radiusB,
					Float32 minAngle,
					Float32 maxAngle,
					Float32 stepDegrees = 10.0f );

	void DrawArc(	Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer,
					const btVector3& center,
					const btVector3& normal,
					const btVector3& axis,
					Float32 radiusA,
					Float32 radiusB,
					Float32 minAngle,
					Float32 maxAngle,
					Boolean bDrawSect,
					Float32 stepDegrees = btScalar( 10.0f ) );

	void DrawSpherePatch(	Mix::Graphics::Utility::IPerspectiveRenderer* pPerspectiveRenderer,
							const btVector3& center,
							const btVector3& up,
							const btVector3& axis,
							Float32 radius,
							Float32 minTh,
							Float32 maxTh,
							Float32 minPs,
							Float32 maxPs,
							Float32 stepDegrees = 10.0f,
							Boolean drawCenter = True );
}}}
