#include "Mix/Geometry/OBB.h"

namespace Mix{ namespace Geometry{

OBB::OBB( void )
{
}

OBB::OBB( const Mix::Vector3& c, const Mix::Vector3& ax, const Mix::Vector3& ay, const Mix::Vector3& az, const Mix::Vector3& l )
{
	center = c;
	axis[OBB::AXIS_X] = ax;
	axis[OBB::AXIS_Y] = ay;
	axis[OBB::AXIS_Z] = az;
	length = l;
}

void OBB::ComputePoints( void )
{
	Mix::Vector3 vx;
	Mix::Vector3 vy;
	Mix::Vector3 vz;

	vx = ( axis[OBB::AXIS_X] * length.x );
	vy = ( axis[OBB::AXIS_Y] * length.y );
	vz = ( axis[OBB::AXIS_Z] * length.z );

	points[0] = center - vx + vy + vz;
	points[1] = center + vx + vy + vz;
	points[2] = center + vx + vy - vz;
	points[3] = center - vx + vy - vz;
	points[4] = center - vx - vy + vz;
	points[5] = center + vx - vy + vz;
	points[6] = center + vx - vy - vz;
	points[7] = center - vx - vy - vz;
}

}}
