#pragma once

#include "Mix/Private/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IDomainShader.h"

namespace Mix{ namespace Graphics{ namespace DX11{

	class Device;

	class DomainShader : public Mix::Graphics::IDomainShader, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Class::Graphics::DomainShader
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		static DomainShader* CreateInstance( Mix::Graphics::DX11::Device* pDevice, ID3D11DomainShader* pDomainShader );

	private:
		ID3D11DomainShader* m_pDomainShader;

	private:
		DomainShader( Mix::Graphics::DX11::Device* pDevice, ID3D11DomainShader* pDomainShader );
		virtual ~DomainShader( void );

	public:
		ID3D11DomainShader* GetInterface( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};

}}}
