#include "Mix/Private/Graphics/DX11/GeometryShader.h"
#include "Mix/Private/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX11::GeometryShader
////////////////////////////////////////////////////////////////////////////////////////////////////

GeometryShader* GeometryShader::CreateInstance( Mix::Graphics::DX11::Device* pDevice, ID3D11GeometryShader* pGeometryShader )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, GeometryShader, pDevice, pGeometryShader );
}

GeometryShader::GeometryShader( Mix::Graphics::DX11::Device* pDevice, ID3D11GeometryShader* pGeometryShader ) :
DeviceObject( pDevice ),
m_pGeometryShader( pGeometryShader )
{
}

GeometryShader::~GeometryShader( void )
{
	MIX_RELEASE( m_pGeometryShader );
}

ID3D11GeometryShader* GeometryShader::GetInterface( void )
{
	return m_pGeometryShader;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE GeometryShader::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::GEOMETRY_SHADER;
}

}}}
