#pragma once

#include "Mix/Private/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IGeometryShader.h"

namespace Mix{ namespace Graphics{ namespace DX11{

	class Device;

	class GeometryShader : public Mix::Graphics::IGeometryShader, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX11::GeometryShader
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		static GeometryShader* CreateInstance( Mix::Graphics::DX11::Device* pDevice, ID3D11GeometryShader* pGeometryShader );

	private:
		ID3D11GeometryShader* m_pGeometryShader;

	private:
		GeometryShader( Mix::Graphics::DX11::Device* pDevice, ID3D11GeometryShader* pGeometryShader );
		virtual ~GeometryShader( void );

	public:
		ID3D11GeometryShader* GetInterface( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};

}}}
