#pragma once

#include "Mix/Private/Graphics/Common/Manager.h"

namespace Mix{ namespace Graphics{ namespace DX11{

	class Device;

	class Manager : public Mix::Graphics::Common::Manager
	{
	public:
		static Manager* CreateInstance( void );

	private:
		Mix::Graphics::DX11::Device* m_pDevice;

	private:
		Manager( void );
		virtual ~Manager( void );

	protected:
		virtual Boolean OnInitialize(	const Mix::Point& targetSize,
										Mix::Graphics::SHADER_MODEL shaderModel, Boolean bFullscreen, Boolean bWaitVSync,
										Mix::UserFile* pSysReport );

		virtual void OnDispose( void );

		virtual void GetShaderBinary( Common::Manager::SHADER_TYPES type, Common::Manager::SHADER_BINARY& out );

	public:
		virtual Mix::Graphics::Common::Device* GetDevicePtr( void );
	};

}}}
