#pragma once

#include "Mix/Private/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IQuery.h"

namespace Mix{ namespace Graphics{ namespace DX11{

	class Device;

	class Query : public Mix::Graphics::IQuery, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX11::Query
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		static Query* CreateInstance( Mix::Graphics::DX11::Device* pDevice, Mix::Graphics::QUERY_FORMAT format, ID3D11Query* pD3DQuery );

	private:
		Mix::Graphics::DX11::Device* m_pDevice;
		Mix::Graphics::QUERY_FORMAT m_Format;
		ID3D11Query* m_pD3DQuery;

	private:
		Query( Mix::Graphics::DX11::Device* pDevice, Mix::Graphics::QUERY_FORMAT format, ID3D11Query* pD3DQuery );
		virtual ~Query( void );

	public:
		virtual void Begin( void );
		virtual void End( void );
		virtual Boolean GetData( UInt32& data, Boolean bFlush = True ) const;
		virtual Mix::Graphics::QUERY_FORMAT GetFormat( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};

}}}
