#include "Mix/Private/Graphics/DX11/TexturePlane.h"
#include "Mix/Private/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX11::TexturePlane
////////////////////////////////////////////////////////////////////////////////////////////////////

TexturePlane* TexturePlane::CreateInstance(	Mix::Graphics::DX11::Device* pDevice,
											const wchar_t* pFilePath,
											UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
											ID3D11Texture2D* pTexture, ID3D11ShaderResourceView* pSRView )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, TexturePlane, pDevice, pFilePath, width, height, format, pTexture, pSRView );
}

TexturePlane::TexturePlane(	Mix::Graphics::DX11::Device* pDevice,
							const wchar_t* pFilePath,
							UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
							ID3D11Texture2D* pTexture, ID3D11ShaderResourceView* pSRView ) :
DeviceObject( pDevice ),
m_pDevice( pDevice ),
m_FilePath( pFilePath ),
m_Width( width ),
m_Height( height ),
m_Format( format ),
m_pTexture( pTexture ),
m_pSRView( pSRView ),
m_bLock( False )
{
	MIX_ASSERT( pDevice != NULL );

	MIX_ADD_REF( pDevice );
	m_pDevice = pDevice;
}

TexturePlane::~TexturePlane( void )
{
	MIX_RELEASE( m_pSRView );
	MIX_RELEASE( m_pTexture );
	MIX_RELEASE( m_pDevice );
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX11::Texture
////////////////////////////////////////////////////////////////////////////////////////////////////

ID3D11Resource* TexturePlane::GetInterface( void )
{
	return m_pTexture;
}

ID3D11ShaderResourceView* TexturePlane::GetSRView( void )
{
	return m_pSRView;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::ITexture
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::ITexture::DIMENSION_TYPE TexturePlane::GetDimensionType( void ) const
{
	return ITexture::DIMENSION_PLANE;
}

Mix::Graphics::ITexture::BIND_TYPE TexturePlane::GetBindType( void ) const
{
	return ITexture::BIND_DEFAULT;
}

UInt32 TexturePlane::GetAccessFlags( void ) const
{
	return ITexture::ACCESS_GPU_READ;
}

UInt32 TexturePlane::GetWidth( void ) const
{
	return m_Width;
}

UInt32 TexturePlane::GetHeight( void ) const
{
	return m_Height;
}

Mix::Graphics::FORMAT TexturePlane::GetFormat( void ) const
{
	return m_Format;
}

const wchar_t* TexturePlane::GetFilePath( void ) const
{
	return m_FilePath.GetConstPtr();
}

Boolean TexturePlane::Lock( Mix::Graphics::ITexture::LOCK& lock )
{
	return False;
}

void TexturePlane::Unlock( void )
{
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE TexturePlane::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::TEXTURE;
}

}}}
