#include "Mix/Private/Graphics/DX11/TextureTarget.h"
#include "Mix/Private/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX11::TextureTarget
////////////////////////////////////////////////////////////////////////////////////////////////////

TextureTarget* TextureTarget::CreateInstance(	Mix::Graphics::DX11::Device* pDevice,
												UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
												ID3D11Texture2D* pTexture, ID3D11RenderTargetView* pRTView, ID3D11ShaderResourceView* pSRView )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, TextureTarget, pDevice, width, height, format, pTexture, pRTView, pSRView );
}

TextureTarget::TextureTarget(	Mix::Graphics::DX11::Device* pDevice,
								UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
								ID3D11Texture2D* pTexture, ID3D11RenderTargetView* pRTView, ID3D11ShaderResourceView* pSRView ) :
DeviceObject( pDevice ),
m_Width( width ),
m_Height( height ),
m_Format( format ),
m_pTexture( pTexture ),
m_pRTView( pRTView ),
m_pSRView( pSRView )
{
	MIX_ASSERT( pTexture != NULL );
	MIX_ASSERT( pRTView != NULL );
	MIX_ASSERT( pSRView != NULL );
}

TextureTarget::~TextureTarget( void )
{
	MIX_RELEASE( m_pSRView );
	MIX_RELEASE( m_pRTView );
	MIX_RELEASE( m_pTexture );
}

ID3D11RenderTargetView* TextureTarget::GetRTView( void )
{
	return m_pRTView;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX11::Texture
////////////////////////////////////////////////////////////////////////////////////////////////////

ID3D11Resource* TextureTarget::GetInterface( void )
{
	return m_pTexture;
}

ID3D11ShaderResourceView* TextureTarget::GetSRView( void )
{
	return m_pSRView;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::ITexture
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::ITexture::DIMENSION_TYPE TextureTarget::GetDimensionType( void ) const
{
	return ITexture::DIMENSION_PLANE;
}

Mix::Graphics::ITexture::BIND_TYPE TextureTarget::GetBindType( void ) const
{
	return ITexture::BIND_TARGET;
}

UInt32 TextureTarget::GetAccessFlags( void ) const
{
	return ITexture::ACCESS_GPU_READ | ITexture::ACCESS_GPU_WRITE;
}

UInt32 TextureTarget::GetWidth( void ) const
{
	return m_Width;
}

UInt32 TextureTarget::GetHeight( void ) const
{
	return m_Height;
}

Mix::Graphics::FORMAT TextureTarget::GetFormat( void ) const
{
	return m_Format;
}

const wchar_t* TextureTarget::GetFilePath( void ) const
{
	return Mix::STR_NULL;
}

Boolean TextureTarget::Lock( Mix::Graphics::ITexture::LOCK& lock )
{
	return False;
}

void TextureTarget::Unlock( void )
{
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE TextureTarget::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::TEXTURE;
}

}}}
