#include "Mix/Private/Graphics/DX11/TextureVolume.h"
#include "Mix/Private/Graphics/DX11/Device.h"

namespace Mix{ namespace Graphics{ namespace DX11{

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX11::TextureVolume
////////////////////////////////////////////////////////////////////////////////////////////////////

TextureVolume* TextureVolume::CreateInstance(	Mix::Graphics::DX11::Device* pDevice,
												const wchar_t* pFilePath,
												UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
												ID3D11Texture3D* pTexture, ID3D11ShaderResourceView* pSRView )
{
	return MIX_LIB_NEW_T( Mix::Memory::SECTION_GRAPHICS, TextureVolume, pDevice, pFilePath, width, height, format, pTexture, pSRView );
}

TextureVolume::TextureVolume(	Mix::Graphics::DX11::Device* pDevice,
								const wchar_t* pFilePath,
								UInt32 width, UInt32 height, Mix::Graphics::FORMAT format,
								ID3D11Texture3D* pTexture, ID3D11ShaderResourceView* pSRView ) :
DeviceObject( pDevice ),
m_pDevice( NULL ),
m_FilePath( pFilePath ),
m_Width( width ),
m_Height( height ),
m_Format( format ),
m_pTexture( NULL ),
m_pSRView( NULL )
{
	MIX_ASSERT( pDevice != NULL );
	MIX_ASSERT( pTexture != NULL );
	MIX_ASSERT( pSRView != NULL );

	MIX_ADD_REF( pDevice );
	m_pDevice = pDevice;

	m_pTexture = pTexture;
	m_pSRView = pSRView;
}

TextureVolume::~TextureVolume( void )
{
	MIX_RELEASE( m_pSRView );
	MIX_RELEASE( m_pTexture );
	MIX_RELEASE( m_pDevice );
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::DX11::Texture
////////////////////////////////////////////////////////////////////////////////////////////////////

ID3D11Resource* TextureVolume::GetInterface( void )
{
	return m_pTexture;
}

ID3D11ShaderResourceView* TextureVolume::GetSRView( void )
{
	return m_pSRView;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::ITexture
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::ITexture::DIMENSION_TYPE TextureVolume::GetDimensionType( void ) const
{
	return ITexture::DIMENSION_VOLUME;
}

Mix::Graphics::ITexture::BIND_TYPE TextureVolume::GetBindType( void ) const
{
	return ITexture::BIND_DEFAULT;
}

UInt32 TextureVolume::GetAccessFlags( void ) const
{
	return ITexture::ACCESS_GPU_READ;
}

UInt32 TextureVolume::GetWidth( void ) const
{
	return m_Width;
}

UInt32 TextureVolume::GetHeight( void ) const
{
	return m_Height;
}

Mix::Graphics::FORMAT TextureVolume::GetFormat( void ) const
{
	return m_Format;
}

const wchar_t* TextureVolume::GetFilePath( void ) const
{
	return m_FilePath.GetConstPtr();
}

Boolean TextureVolume::Lock( Mix::Graphics::ITexture::LOCK& lock )
{
	return False;
}

void TextureVolume::Unlock( void )
{
}

////////////////////////////////////////////////////////////////////////////////////////////////////
// Mix::Graphics::IDeviceObject
////////////////////////////////////////////////////////////////////////////////////////////////////

Mix::Graphics::IDeviceObject::TYPE TextureVolume::GetType( void ) const
{
	return Mix::Graphics::IDeviceObject::TEXTURE;
}

}}}
