#pragma once

#include "Mix/Private/Graphics/Common/DeviceObject.h"
#include "Mix/Graphics/IVertexBuffer.h"

namespace Mix{ namespace Graphics{ namespace DX11{

	class Device;

	class VertexBuffer : public Mix::Graphics::IVertexBuffer, public Mix::Graphics::Common::DeviceObject
	{
		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::DX11::VertexBuffer
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		static VertexBuffer* CreateInstance(	Mix::Graphics::DX11::Device* pDevice,
												UInt32 count, UInt32 stride,
												Boolean bDynamic, UInt32 resizeStep );

	private:
		Mix::Graphics::DX11::Device* m_pDevice;

		ID3D11Buffer* m_pVertexBuffer;
		D3D11_MAPPED_SUBRESOURCE m_Mapped;

		UInt32 m_Stride;

		Boolean m_bDynamic;
		UInt32 m_ResizeStep;

		Boolean m_bLock;
		Boolean m_bResize;

		UInt8* m_pBuffer;
		UInt8* m_pSource;

		UInt32 m_Capacity;
		UInt32 m_Count;

	private:
		VertexBuffer(	Mix::Graphics::DX11::Device* pDevice,
						UInt32 count, UInt32 stride,
						Boolean bDynamic, UInt32 resizeStep );

		virtual ~VertexBuffer( void );

	public:
		HRESULT Initialize( const void* pInitialData );
		ID3D11Buffer* GetInsterface( void );

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IVertexBuffer
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Boolean Lock( void );
		virtual void Unlock( void );

		virtual Boolean Push( const void* pData, UInt32 count );
		virtual void* Push( UInt32 count );

		virtual void Clear( void );

		virtual UInt32 GetStride( void ) const;

		virtual UInt32 GetCount( void ) const;
		virtual UInt32 GetCapacity( void ) const;

		////////////////////////////////////////////////////////////////////////////////////////////////////
		// Mix::Graphics::IDeviceObject
		////////////////////////////////////////////////////////////////////////////////////////////////////

	public:
		virtual Mix::Graphics::IDeviceObject::TYPE GetType( void ) const;
	};

}}}
